"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.peerRecoverySaga = exports.setDevicePeerRecovery = void 0;
const socketActionCreator_1 = require("../../../Socket/socketActionCreator");
const effects_1 = require("redux-saga/effects");
const devicePeerRecoveryActions_1 = require("@signageos/actions/dist/Device/PeerRecovery/devicePeerRecoveryActions");
const ManagementCapability_1 = __importDefault(require("../../../NativeDevice/Management/ManagementCapability"));
const Responsibility_1 = __importDefault(require("../../../Feature/Responsibility"));
function* setDevicePeerRecovery(getNativeDriver, action) {
    const nativeDriver = getNativeDriver();
    try {
        const configuration = action.enabled
            ? { enabled: true, urlLauncherAddress: action.urlLauncherAddress }
            : { enabled: false, autoEnableTimeoutMs: action.autoEnableTimeoutMs };
        yield (0, effects_1.call)([nativeDriver, 'setPeerRecovery'], configuration);
        yield (0, effects_1.put)({
            type: devicePeerRecoveryActions_1.SetDevicePeerRecoverySucceeded,
            uid: action.uid,
        });
    }
    catch (error) {
        yield (0, effects_1.put)({
            type: devicePeerRecoveryActions_1.SetDevicePeerRecoveryFailed,
            uid: action.uid,
        });
    }
}
exports.setDevicePeerRecovery = setDevicePeerRecovery;
function* peerRecoverySaga(getNativeDriver, responsibilities) {
    if (!responsibilities.has(Responsibility_1.default.PEER_RECOVERY)) {
        return;
    }
    const nativeDriver = getNativeDriver();
    const supportPRenabled = yield (0, effects_1.call)([nativeDriver, 'managementSupports'], ManagementCapability_1.default.PEER_RECOVERY);
    if (supportPRenabled) {
        yield (0, socketActionCreator_1.bindAndTakeEveryOnlyWhenPlatform)(devicePeerRecoveryActions_1.SetDevicePeerRecovery, setDevicePeerRecovery, getNativeDriver);
    }
}
exports.peerRecoverySaga = peerRecoverySaga;
//# sourceMappingURL=peerRecoverySaga.js.map