"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.displayManagerSaga = void 0;
const effects_1 = require("redux-saga/effects");
const ManagementCapability_1 = __importDefault(require("../../../NativeDevice/Management/ManagementCapability"));
const Responsibility_1 = __importDefault(require("../../../Feature/Responsibility"));
const periodicTaskSaga_1 = require("../../../Saga/periodicTaskSaga");
const responsible_1 = require("../../../Feature/responsible");
const capable_1 = require("../../../Feature/capable");
const dependencyInjection_1 = require("../../../DI/dependencyInjection");
const experimentalActions_1 = require("../../../Experimental/experimentalActions");
const ConnectedDisplayOverSerial = 'DisplayManager.ConnectedDisplayOverSerial';
exports.displayManagerSaga = (0, responsible_1.whenResponsible)(Responsibility_1.default.DISPLAY_MANAGER, (0, capable_1.whenCapable)(ManagementCapability_1.default.DISPLAY_MANAGER, displayManagerSagaDefault));
function* displayManagerSagaDefault() {
    yield (0, effects_1.fork)((0, capable_1.whenCapable)(ManagementCapability_1.default.DISPLAY_MANAGER, (0, dependencyInjection_1.withDependencies)(['managementDriver'], function* ({ managementDriver }) {
        yield (0, periodicTaskSaga_1.runPeriodicTaskSagaUntilSuccessWhilePlatform)(10e3, 60e3, function* () {
            const connectedDisplay = yield managementDriver.displayManager.getConnectedDisplay();
            const isSerialConnectionAvailable = yield managementDriver.displayManager.isSerialConnectionAvailable();
            if (connectedDisplay) {
                //TODO: Change to systemLogs when will be working again
                yield (0, experimentalActions_1.putExperimental)({
                    type: ConnectedDisplayOverSerial,
                    display: connectedDisplay,
                    success: isSerialConnectionAvailable,
                });
            }
        });
    })));
}
//# sourceMappingURL=displayManagerSaga.js.map