"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getDebugSettings = exports.telemetryDeviceDebugSaga = void 0;
const DeviceTelemetryType_1 = require("@signageos/common-types/dist/Device/Telemetry/DeviceTelemetryType");
const deviceTelemetrySagas_1 = require("../Telemetry/deviceTelemetrySagas");
const Property_1 = __importDefault(require("../../../Property/Property"));
const Responsibility_1 = __importDefault(require("../../../Feature/Responsibility"));
exports.telemetryDeviceDebugSaga = (0, deviceTelemetrySagas_1.createDeviceTelemetrySaga)(DeviceTelemetryType_1.DeviceTelemetryType.DEBUG, Responsibility_1.default.DEBUG, [], getDebugSettings);
function getDebugSettings({ managementDriver, propertyStorage }) {
    return __awaiter(this, void 0, void 0, function* () {
        const appletEnabled = yield propertyStorage.getValueOrDefault(Property_1.default.DEBUG_WEINRE_ENABLED, false);
        return {
            appletEnabled: appletEnabled,
            nativeEnabled: yield managementDriver.isDebugEnabled(),
        };
    });
}
exports.getDebugSettings = getDebugSettings;
//# sourceMappingURL=deviceDebugTelemetrySagas.js.map