"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.setDeviceDebugSettingsCallback = exports.devicePerformDebugSettings = void 0;
const socketActionCreator_1 = require("../../../Socket/socketActionCreator");
const effects_1 = require("redux-saga/effects");
const deviceDebugActions_1 = require("@signageos/actions/dist/Device/Debug/deviceDebugActions");
const ManagementCapability_1 = __importDefault(require("../../../NativeDevice/Management/ManagementCapability"));
const Responsibility_1 = __importDefault(require("../../../Feature/Responsibility"));
const processCallback_1 = __importDefault(require("../../../Util/processCallback"));
function* devicePerformDebugSettings(getNativeDriver, responsibilities) {
    if (!responsibilities.has(Responsibility_1.default.DEBUG)) {
        return;
    }
    yield (0, socketActionCreator_1.bindWhenPlatform)(deviceDebugActions_1.SetDeviceDebugSettings);
    const supportsDebug = yield getNativeDriver().managementSupports(ManagementCapability_1.default.SET_DEBUG);
    if (supportsDebug) {
        yield (0, effects_1.takeEvery)(deviceDebugActions_1.SetDeviceDebugSettings, setDeviceDebugSettingsCallback, getNativeDriver);
    }
}
exports.devicePerformDebugSettings = devicePerformDebugSettings;
function* setDeviceDebugSettingsCallback(getNativeDriver, { nativeEnabled, uid }) {
    const nativeDriver = getNativeDriver();
    try {
        const finalizeCallback = yield (0, effects_1.apply)(nativeDriver, nativeDriver.setDebug, [nativeEnabled]);
        yield (0, effects_1.put)({
            type: deviceDebugActions_1.SetDeviceDebugSettingsSucceeded,
            uid,
        });
        yield (0, effects_1.call)(processCallback_1.default, finalizeCallback);
    }
    catch (e) {
        yield (0, effects_1.put)({
            type: deviceDebugActions_1.SetDeviceDebugSettingsFailed,
            uid,
        });
    }
}
exports.setDeviceDebugSettingsCallback = setDeviceDebugSettingsCallback;
//# sourceMappingURL=deviceDebugSettingsSagas.js.map