"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getCurrentTime = exports.setNtpOrManualTime = void 0;
function setNtpOrManualTime(nativeDriver, timestampMs, timezone, ntpServer) {
    return __awaiter(this, void 0, void 0, function* () {
        if (ntpServer && (yield nativeDriver.timeManager.canSetAuto())) {
            return yield nativeDriver.timeManager.setAuto(ntpServer, timezone);
        }
        else if (yield nativeDriver.timeManager.canSetManual()) {
            return yield nativeDriver.timeManager.setManual(timestampMs, timezone);
        }
        throw new Error('Device is not able to set time & timezone');
    });
}
exports.setNtpOrManualTime = setNtpOrManualTime;
function getCurrentTime(nativeDriver) {
    var _a;
    return __awaiter(this, void 0, void 0, function* () {
        let settings = {
            timestamp: yield nativeDriver.timeManager.getEpochMillis(),
            timezone: null,
            timezoneOffset: (yield nativeDriver.timeManager.getZoneOffset()).toPosix(),
            ntpEnabled: yield nativeDriver.timeManager.isAutoEnabled(),
        };
        if (yield nativeDriver.timeManager.canGetZoneId()) {
            settings = Object.assign(Object.assign({}, settings), { timezone: yield nativeDriver.timeManager.getZoneId() });
        }
        if (yield nativeDriver.timeManager.canGetNtpServer()) {
            settings = Object.assign(Object.assign({}, settings), { ntpServer: (_a = (yield nativeDriver.timeManager.getNtpServer())) !== null && _a !== void 0 ? _a : undefined });
        }
        return settings;
    });
}
exports.getCurrentTime = getCurrentTime;
//# sourceMappingURL=dateTimeFacade.js.map