"use strict";
var __await = (this && this.__await) || function (v) { return this instanceof __await ? (this.v = v, this) : new __await(v); }
var __asyncGenerator = (this && this.__asyncGenerator) || function (thisArg, _arguments, generator) {
    if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
    var g = generator.apply(thisArg, _arguments || []), i, q = [];
    return i = {}, verb("next"), verb("throw"), verb("return", awaitReturn), i[Symbol.asyncIterator] = function () { return this; }, i;
    function awaitReturn(f) { return function (v) { return Promise.resolve(v).then(f, reject); }; }
    function verb(n, f) { if (g[n]) { i[n] = function (v) { return new Promise(function (a, b) { q.push([n, v, a, b]) > 1 || resume(n, v); }); }; if (f) i[n] = f(i[n]); } }
    function resume(n, v) { try { step(g[n](v)); } catch (e) { settle(q[0][3], e); } }
    function step(r) { r.value instanceof __await ? Promise.resolve(r.value.v).then(fulfill, reject) : settle(q[0][2], r); }
    function fulfill(value) { resume("next", value); }
    function reject(value) { resume("throw", value); }
    function settle(f, v) { if (f(v), q.shift(), q.length) resume(q[0][0], q[0][1]); }
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.checkAndSetBrightnessSettings = exports.deviceBrightnessPolicySaga = void 0;
const DeviceSettingsType_1 = require("@signageos/common-types/dist/Device/Settings/DeviceSettingsType");
const devicePolicySagas_1 = require("../Policy/devicePolicySagas");
const brightnessTelemetrySagas_1 = require("./brightnessTelemetrySagas");
const screenHelper_1 = require("../../../NativeDevice/Screen/screenHelper");
const ManagementCapability_1 = __importDefault(require("../../../NativeDevice/Management/ManagementCapability"));
const Responsibility_1 = __importDefault(require("../../../Feature/Responsibility"));
exports.deviceBrightnessPolicySaga = (0, devicePolicySagas_1.createDevicePolicySaga)(DeviceSettingsType_1.DeviceSettingsType.BRIGHTNESS, Responsibility_1.default.BRIGHTNESS, ManagementCapability_1.default.SET_BRIGHTNESS, checkAndSetBrightnessSettings);
function checkAndSetBrightnessSettings(properties) {
    var _a, _b, _c, _d, _e, _f, _g, _h;
    return __asyncGenerator(this, arguments, function* checkAndSetBrightnessSettings_1() {
        const { brightness: currentBrightnessSettings } = yield __await((0, brightnessTelemetrySagas_1.getBrightnessSettings)(properties));
        const { policy, managementDriver } = properties;
        if (policy.value === undefined) {
            return yield __await(devicePolicySagas_1.CheckAndSetResult.NOT_CHANGED);
        }
        const proposedBrightnessSettings = (0, screenHelper_1.resolveCurrentBrightness)(policy.value[0].time, policy.value[0].brightness, (_b = (_a = policy.value[1]) === null || _a === void 0 ? void 0 : _a.time) !== null && _b !== void 0 ? _b : policy.value[0].time, (_d = (_c = policy.value[1]) === null || _c === void 0 ? void 0 : _c.brightness) !== null && _d !== void 0 ? _d : policy.value[0].brightness, new Date());
        if (currentBrightnessSettings !== proposedBrightnessSettings) {
            yield __await(managementDriver.screenSetBrightness(policy.value[0].time, policy.value[0].brightness, (_f = (_e = policy.value[1]) === null || _e === void 0 ? void 0 : _e.time) !== null && _f !== void 0 ? _f : policy.value[0].time, (_h = (_g = policy.value[1]) === null || _g === void 0 ? void 0 : _g.brightness) !== null && _h !== void 0 ? _h : policy.value[0].brightness));
            return yield __await(devicePolicySagas_1.CheckAndSetResult.CHANGED);
        }
        return yield __await(devicePolicySagas_1.CheckAndSetResult.NOT_CHANGED);
    });
}
exports.checkAndSetBrightnessSettings = checkAndSetBrightnessSettings;
//# sourceMappingURL=brightnessPolicySagas.js.map