"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.deviceBatterySaga = void 0;
const effects_1 = require("redux-saga/effects");
const ManagementCapability_1 = __importDefault(require("../../../NativeDevice/Management/ManagementCapability"));
const batteryActions_1 = require("@signageos/actions/dist/Device/Battery/batteryActions");
const Responsibility_1 = __importDefault(require("../../../Feature/Responsibility"));
const capable_1 = require("../../../Feature/capable");
const dependencyInjection_1 = require("../../../DI/dependencyInjection");
const deviceTelemetryHelper_1 = require("../Telemetry/deviceTelemetryHelper");
const deviceBatterySaga = () => (0, capable_1.whenCapable)(ManagementCapability_1.default.BATTERY_STATUS, (0, dependencyInjection_1.withDependencies)(['managementDriver', 'responsibilities', 'telemetryIntervals'], function* ({ managementDriver, responsibilities, telemetryIntervals }) {
    var _a;
    if (!responsibilities.has(Responsibility_1.default.BATTERY)) {
        return;
    }
    const periodMs = (_a = telemetryIntervals === null || telemetryIntervals === void 0 ? void 0 : telemetryIntervals.battery) !== null && _a !== void 0 ? _a : 0;
    yield (0, deviceTelemetryHelper_1.registerTelemetry)('BATTERY', periodMs, function* () {
        try {
            const batteryStatus = yield managementDriver.batteryGetStatus();
            yield (0, effects_1.put)({
                type: batteryActions_1.NotifyBatteryStatus,
                batteryStatus,
            });
        }
        catch (error) {
            console.error('deviceBatterySaga', error);
        }
    });
}));
exports.deviceBatterySaga = deviceBatterySaga;
//# sourceMappingURL=deviceBatterySaga.js.map