"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.autoRecoverySaga = exports.setDeviceAutoRecovery = void 0;
const socketActionCreator_1 = require("../../../Socket/socketActionCreator");
const effects_1 = require("redux-saga/effects");
const deviceAutoRecoveryActions_1 = require("@signageos/actions/dist/Device/AutoRecovery/deviceAutoRecoveryActions");
const ManagementCapability_1 = __importDefault(require("../../../NativeDevice/Management/ManagementCapability"));
const Responsibility_1 = __importDefault(require("../../../Feature/Responsibility"));
function* setDeviceAutoRecovery(getNativeDriver, action) {
    const nativeDriver = getNativeDriver();
    try {
        const configuration = action.enabled
            ? { enabled: true, healthcheckIntervalMs: action.healthcheckIntervalMs }
            : { enabled: false, autoEnableTimeoutMs: action.autoEnableTimeoutMs };
        yield (0, effects_1.call)([nativeDriver, 'setAutoRecovery'], configuration);
        yield (0, effects_1.put)({
            type: deviceAutoRecoveryActions_1.SetDeviceAutoRecoverySucceeded,
            uid: action.uid,
        });
    }
    catch (error) {
        yield (0, effects_1.put)({
            type: deviceAutoRecoveryActions_1.SetDeviceAutoRecoveryFailed,
            uid: action.uid,
        });
    }
}
exports.setDeviceAutoRecovery = setDeviceAutoRecovery;
function* autoRecoverySaga(getNativeDriver, responsibilities) {
    if (!responsibilities.has(Responsibility_1.default.AUTO_RECOVERY)) {
        return;
    }
    const nativeDriver = getNativeDriver();
    const isSupported = yield (0, effects_1.call)([nativeDriver, 'managementSupports'], ManagementCapability_1.default.AUTO_RECOVERY);
    if (isSupported) {
        yield (0, socketActionCreator_1.bindAndTakeEveryOnlyWhenPlatform)(deviceAutoRecoveryActions_1.SetDeviceAutoRecovery, setDeviceAutoRecovery, getNativeDriver);
    }
}
exports.autoRecoverySaga = autoRecoverySaga;
//# sourceMappingURL=autoRecoverySagas.js.map