"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.pinging = void 0;
const applicationActions_1 = require("@signageos/actions/dist/Application/applicationActions");
const wait_1 = __importDefault(require("@signageos/lib/dist/Timer/wait"));
const effects_1 = require("redux-saga/effects");
const deviceConfigurationActions_1 = require("../../Device/Configuration/deviceConfigurationActions");
const PLATFORM_PERIOD = 30e3;
const OPEN_PERIOD = 30 * 60e3;
function* pinging() {
    let isPlatform = false;
    yield (0, effects_1.takeEvery)(deviceConfigurationActions_1.ChangeSubscriptionToOpen, function* () {
        isPlatform = false;
    });
    yield (0, effects_1.takeEvery)(deviceConfigurationActions_1.ChangeSubscriptionToPlatform, function* () {
        isPlatform = true;
    });
    yield (0, effects_1.takeEvery)(applicationActions_1.StartApplication, function* () {
        try {
            yield (0, wait_1.default)(1e3);
            while (true) {
                yield (0, effects_1.put)({ type: applicationActions_1.Ping });
                const nextPingInMs = isPlatform ? PLATFORM_PERIOD : OPEN_PERIOD;
                yield (0, effects_1.race)({
                    platform: (0, effects_1.take)(deviceConfigurationActions_1.ChangeSubscriptionToPlatform),
                    open: (0, effects_1.take)(deviceConfigurationActions_1.ChangeSubscriptionToOpen),
                    wait: (0, effects_1.call)(wait_1.default, nextPingInMs),
                });
            }
        }
        catch (error) {
            console.error('pinging failed', error);
        }
    });
}
exports.pinging = pinging;
//# sourceMappingURL=pingSagas.js.map