"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getChecksumOfBlob = exports.getChecksumOfFile = exports.checksumString = void 0;
const crypto = __importStar(require("crypto"));
const crc32 = __importStar(require("crc-32"));
function checksumString(message, length = 50) {
    const hash = crypto.createHash('sha256');
    hash.update(message);
    return hash.digest('hex').substring(0, length);
}
exports.checksumString = checksumString;
function getChecksumOfFile(window, uri, algorithm) {
    return __awaiter(this, void 0, void 0, function* () {
        const response = yield window.fetch(uri);
        return yield getChecksumOfBlob(yield response.blob(), algorithm);
    });
}
exports.getChecksumOfFile = getChecksumOfFile;
function getChecksumOfBlob(blob, algorithm) {
    return __awaiter(this, void 0, void 0, function* () {
        const data = Buffer.from(yield blob.arrayBuffer());
        if (algorithm === 'md5') {
            return crypto.createHash('md5').update(data).digest('hex');
        }
        else if (algorithm === 'crc32') {
            const hashNumber = crc32.buf(data);
            const hashUint32 = hashNumber < 0 ? hashNumber + Math.pow(16, 8) : hashNumber;
            return hashUint32.toString(16).padStart(8, '0');
        }
        throw new Error(`Checksum algorithm is not supported: ${algorithm}`);
    });
}
exports.getChecksumOfBlob = getChecksumOfBlob;
//# sourceMappingURL=checksum.js.map