"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.frontSaga = void 0;
const effects_1 = require("redux-saga/effects");
const startApplicationSaga_1 = __importDefault(require("../Application/startApplicationSaga"));
const authenticationSagas_1 = require("../Authentication/authenticationSagas");
const dependenciesSaga_1 = require("../DI/dependenciesSaga");
const debugSagas_1 = require("../Debug/debugSagas");
const deviceConfigurationSagas_1 = require("../Device/Configuration/deviceConfigurationSagas");
const deviceConnectSagas_1 = require("../Device/Connect/deviceConnectSagas");
const deviceAliveSaga_1 = require("../Device/Status/deviceAliveSaga");
const deviceProprietaryTimerSagas_1 = require("../Device/Timer/deviceProprietaryTimerSagas");
const deviceVerificationSagas_1 = require("../Device/Verification/deviceVerificationSagas");
const deviceSagas_1 = require("../Device/deviceSagas");
const combinedDriver_1 = require("../NativeDevice/Default/combinedDriver");
const offlineActionsSagas_1 = require("../Offline/offlineActionsSagas");
const OfflineCache_1 = __importDefault(require("../OfflineCache/OfflineCache"));
const socketHealthCheckSagas_1 = require("../Socket/socketHealthCheckSagas");
const socketSagas_1 = require("../Socket/socketSagas");
const commonSystemLogsSagas_1 = require("../SystemLogs/commonSystemLogsSagas");
const testSagas_1 = require("../Test/testSagas");
const timerResolverFactory_1 = require("../Timer/timerResolverFactory");
const appletBrowserSagas_1 = require("./Applet/Browser/appletBrowserSagas");
const bundledAppletActions_1 = require("./Applet/BundledApplet/bundledAppletActions");
const appletCommandDispatchSagas_1 = require("./Applet/Command/appletCommandDispatchSagas");
const appletDateTimeSagas_1 = require("./Applet/DateTime/appletDateTimeSagas");
const appletFileSystemSagas_1 = require("./Applet/FileSystem/appletFileSystemSagas");
const appletKeySagas_1 = require("./Applet/Input/appletKeySagas");
const appletWifiSagas_1 = require("./Applet/Management/Wifi/appletWifiSagas");
const appletProximitySensorSagas_1 = require("./Applet/Sensors/appletProximitySensorSagas");
const appletStreamSagas_1 = require("./Applet/Stream/appletStreamSagas");
const appletSyncSagas_1 = require("./Applet/Sync/appletSyncSagas");
const appletVideoSagas_1 = require("./Applet/Video/appletVideoSagas");
const appletBinarySagas_1 = require("./Applet/appletBinarySagas");
const appletSagas_1 = require("./Applet/appletSagas");
const defaultApplet_1 = require("./Applet/defaultApplet");
const appletTimingCacheSagas_1 = require("./AppletTiming/appletTimingCacheSagas");
const appletTimingControllerSagas_1 = require("./AppletTiming/appletTimingControllerSagas");
const currentTimeSyncSagas_1 = require("./Device/DateTime/currentTimeSyncSagas");
const deviceDebugSettingsSagas_1 = require("./Device/Debug/deviceDebugSettingsSagas");
const deviceDeprovisionSagas_1 = require("./Device/Deprovision/deviceDeprovisionSagas");
const devicePowerActionSagas_1 = require("./Device/Power/devicePowerActionSagas");
const deviceSchedulePowerActionSagas_1 = require("./Device/Power/deviceSchedulePowerActionSagas");
const deviceRemoteControlSagas_1 = require("./Device/RemoteControl/deviceRemoteControlSagas");
const timerControllerSagas_1 = require("./Device/Timer/timerControllerSagas");
const deviceVerificationSagas_2 = require("./Device/Verification/deviceVerificationSagas");
const deviceAuthenticationSagas_1 = require("./Device/deviceAuthenticationSagas");
const deviceSagas_2 = require("./Device/deviceSagas");
const keySagas_1 = require("./Input/keySagas");
const motionSagas_1 = require("./Input/motionSagas");
const osdSagas_1 = require("./Input/osdSagas");
const softwareKeyboardSagas_1 = require("./Input/softwareKeyboardSagas");
const networkSagas_1 = require("./Network/networkSagas");
const controlEnablingSagas_1 = require("./Security/controlEnablingSagas");
const systemLogsSagas_1 = require("./SystemLogs/systemLogsSagas");
const CacheTest_1 = __importDefault(require("./Tests/CacheTest"));
const FileSystemTest_1 = __importDefault(require("./Tests/FileSystemTest"));
const HTML5Test_1 = __importDefault(require("./Tests/HTML5Test"));
const VideoTest_1 = __importDefault(require("./Tests/VideoTest"));
const WeinreTest_1 = __importDefault(require("./Tests/WeinreTest"));
const touchSaga_1 = require("./Touch/touchSaga");
function* frontSaga(defaultConfig, { publicKey, sessionIdKey, global, nativeDriver, managementDriver, synchronizer, frontAppletPrefix, frontDisplayVersion, autoVerification, webWorkerFactory, applicationVersion, bundledApplet, responsibilities, frontExtraTests, shortAppletFilesUrl, logOfflineActions = true, }, getState, propertyStorage, dispatch) {
    const { frontDriver, cacheDriver } = (0, combinedDriver_1.normalizeFrontCacheDriver)(nativeDriver);
    const offlineCache = new OfflineCache_1.default(frontDriver.fileSystem);
    const getNativeDriver = () => nativeDriver;
    const getFrontDriver = () => frontDriver;
    const getManagementDriver = () => managementDriver;
    const getSynchronizer = () => synchronizer;
    //const dataStorage = createDataStorage(getFrontDriver);
    const defaultTiming = bundledApplet
        ? (0, defaultApplet_1.getDefaultAppletTimingDefinition)(bundledApplet.uid, bundledApplet.version, bundledApplet.frontAppletVersion, bundledApplet.checksum, bundledApplet.config)
        : undefined;
    const defaultTimingData = bundledApplet
        ? {
            appletUid: bundledApplet.uid,
            appletVersion: bundledApplet.version,
            appletBinaryFile: bundledApplet.binaryFile,
            appletFrontAppletJsFile: bundledApplet.frontAppletBinaryFile,
        }
        : undefined;
    const proprietaryTimerStorage = frontDriver.proprietaryTimerStorage;
    const proprietaryTimerManager = (0, timerResolverFactory_1.createProprietaryTimerManagerForFront)(responsibilities, proprietaryTimerStorage);
    yield (0, effects_1.all)([
        // create DI container as first
        (0, dependenciesSaga_1.dependencyInjection)({
            applicationVersion,
            managementDriver,
            frontDriver,
            propertyStorage,
            responsibilities,
            proprietaryTimerStorage,
        }),
        // shared sagas
        (0, socketSagas_1.socketPlatformCreate)(getFrontDriver, 'front', () => managementDriver.timeManager.getEpochMillis(), defaultConfig), // Must be first saga
        (0, socketHealthCheckSagas_1.healthChecking)(),
        (0, deviceConfigurationSagas_1.updatingConfiguration)(getFrontDriver, getManagementDriver, propertyStorage, defaultConfig, publicKey, 'front'),
        (0, authenticationSagas_1.autoDeviceAuthentication)(sessionIdKey, getFrontDriver),
        (0, authenticationSagas_1.storeDeviceSession)(sessionIdKey, getFrontDriver),
        (0, authenticationSagas_1.fallbackDeviceUidAuthentication)(getFrontDriver),
        (0, authenticationSagas_1.afterRegistrationDeviceUidAuthentication)(getFrontDriver),
        (0, deviceSagas_1.fallbackDeviceRegistration)(getFrontDriver, autoVerification),
        // front sagas
        (0, currentTimeSyncSagas_1.startupDeviceDateTimeSettings)(),
        (0, deviceSagas_2.notifyDeviceSaga)(getManagementDriver),
        (0, deviceSagas_1.notifyDeviceFrontDisplayVersion)(frontDisplayVersion),
        (0, deviceSagas_2.notifyDeviceApplicationVersion)(getFrontDriver, applicationVersion),
        (0, appletTimingControllerSagas_1.controlActiveAppletTiming)(webWorkerFactory, defaultTiming ? [defaultTiming] : undefined),
        (0, appletSagas_1.bindAppletMessages)(frontAppletPrefix, global, getState, getNativeDriver, getSynchronizer, offlineCache, shortAppletFilesUrl !== null && shortAppletFilesUrl !== void 0 ? shortAppletFilesUrl : false, proprietaryTimerStorage),
        (0, appletSagas_1.bindAppletIframe)(frontAppletPrefix, global, getState, frontDisplayVersion, getManagementDriver),
        (0, appletSagas_1.updateAppletDeviceAuthHash)(frontAppletPrefix, global, getState),
        (0, appletSagas_1.updateAppletUniqueHash)(),
        (0, appletVideoSagas_1.activeAppletRestore)(getFrontDriver, getSynchronizer),
        (0, appletVideoSagas_1.restoreOnAppletChange)(),
        (0, appletDateTimeSagas_1.currentTimestampEmiting)(global, frontAppletPrefix, getState),
        (0, appletBrowserSagas_1.browserEventEmitting)(global, frontAppletPrefix, getFrontDriver, getState),
        (0, appletVideoSagas_1.videoEventEmitting)(global, frontAppletPrefix, getState),
        (0, appletStreamSagas_1.streamEventEmitting)(global, frontAppletPrefix, getState),
        (0, appletWifiSagas_1.wifiEventEmitting)(global, frontAppletPrefix, getManagementDriver, getState),
        (0, appletProximitySensorSagas_1.proximitySensorStatusChangeEmitting)(global, frontAppletPrefix, getManagementDriver, getState),
        (0, appletSyncSagas_1.syncEventEmitting)(global, frontAppletPrefix, getState, synchronizer),
        (0, appletKeySagas_1.inputKeysEmitting)(global, frontAppletPrefix, getState),
        (0, appletFileSystemSagas_1.storageStatusChangeEmitting)(global, frontAppletPrefix, getFrontDriver, getState),
        (0, deviceAuthenticationSagas_1.startupDeviceAuthHash)(propertyStorage),
        (0, deviceAuthenticationSagas_1.cacheDeviceAuthHash)(propertyStorage),
        (0, deviceVerificationSagas_1.deviceVerification)(getFrontDriver),
        (0, deviceVerificationSagas_2.dispatchVerificationHash)(global),
        (0, deviceDeprovisionSagas_1.deviceDeprovision)(getFrontDriver, getManagementDriver, responsibilities, sessionIdKey),
        (0, devicePowerActionSagas_1.deviceAppletDisablingRestoresActiveApplet)(),
        (0, deviceSchedulePowerActionSagas_1.deviceSchedulePowerAction)(propertyStorage),
        (0, devicePowerActionSagas_1.devicePerformScheduledPowerAction)(getNativeDriver, propertyStorage, offlineCache),
        (0, timerControllerSagas_1.appletTimerChecking)(responsibilities, proprietaryTimerManager),
        (0, deviceRemoteControlSagas_1.startupDeviceRemoteControlSettingsSaga)(getFrontDriver),
        (0, keySagas_1.keyUpSaga)(getFrontDriver),
        (0, keySagas_1.keySequenceSaga)(global),
        (0, motionSagas_1.motionSequenceSaga)(global),
        (0, softwareKeyboardSagas_1.bindNumericKeyboardSaga)(),
        (0, controlEnablingSagas_1.controlEnablingSaga)(),
        (0, controlEnablingSagas_1.generateControlPinSaga)(),
        (0, controlEnablingSagas_1.reportDevicePinChangedSaga)(),
        (0, deviceConnectSagas_1.deviceConnectSaga)(),
        (0, osdSagas_1.showOSDSaga)(getFrontDriver, propertyStorage),
        (0, networkSagas_1.networkConnection)(getState, getFrontDriver, getManagementDriver),
        (0, touchSaga_1.touchSaga)(frontAppletPrefix, getState, getFrontDriver, global),
        (0, deviceSagas_2.updateTitle)(global),
        (0, deviceSagas_2.updateDeviceLocation)(propertyStorage),
        (0, deviceSagas_2.updateOrganizationTags)(propertyStorage),
        (0, appletCommandDispatchSagas_1.dispatchAppletCommandToApplet)(frontAppletPrefix, global, getState, bundledApplet),
        (0, deviceDebugSettingsSagas_1.devicePerformDebugSettings)(global, getFrontDriver, propertyStorage, frontAppletPrefix, getState),
        (0, deviceDebugSettingsSagas_1.readSetDeviceDebugSettings)(global, getFrontDriver, propertyStorage, frontAppletPrefix, getState),
        (0, devicePowerActionSagas_1.devicePerformPowerAction)(getNativeDriver, propertyStorage, offlineCache),
        (0, deviceProprietaryTimerSagas_1.syncProprietaryTimerSaga)(),
        (0, testSagas_1.runTestsSaga)([
            (0, CacheTest_1.default)(cacheDriver),
            (0, FileSystemTest_1.default)(frontDriver),
            (0, HTML5Test_1.default)(dispatch),
            (0, VideoTest_1.default)(frontDriver),
            (0, WeinreTest_1.default)(global),
            ...(frontExtraTests !== null && frontExtraTests !== void 0 ? frontExtraTests : []),
        ]),
        (0, appletBinarySagas_1.activeAppletBinary)(getState, getFrontDriver),
        (0, appletTimingCacheSagas_1.loadAppletTimingsDefinition)(propertyStorage),
        (0, appletTimingCacheSagas_1.saveAppletTimingsDefinition)(propertyStorage),
        (0, appletTimingCacheSagas_1.deleteAppletTimingsDefinition)(propertyStorage, defaultTiming ? [defaultTiming] : undefined),
        (0, appletTimingCacheSagas_1.saveAppletBinary)(),
        (0, appletBinarySagas_1.updateActiveAppletBinaryFile)(shortAppletFilesUrl !== null && shortAppletFilesUrl !== void 0 ? shortAppletFilesUrl : false, offlineCache, defaultTimingData),
        ...(logOfflineActions ? [(0, offlineActionsSagas_1.offlineActionsSaga)('front.', getFrontDriver, getManagementDriver)] : []),
        (0, commonSystemLogsSagas_1.commonSystemLogsSaga)(),
        (0, systemLogsSagas_1.systemLogsSaga)(getManagementDriver),
        (0, debugSagas_1.debugAllActions)(),
        ...(bundledApplet
            ? [
                (0, effects_1.put)({
                    type: bundledAppletActions_1.NotifyBundledApplet,
                    bundledApplet: bundledApplet,
                }),
            ]
            : []),
        (0, startApplicationSaga_1.default)(),
        (0, deviceAliveSaga_1.notifyDeviceStatus)(),
        (0, deviceSagas_2.notifyFrontCapabilities)(propertyStorage, getFrontDriver),
        (0, appletSagas_1.notifyAppletTelemetry)(propertyStorage),
        (0, deviceSagas_2.getDeviceLocationAndTags)(),
    ]);
}
exports.frontSaga = frontSaga;
//# sourceMappingURL=frontSagas.js.map