import { Dispatch } from 'redux';
import IConfig from '../Display/IConfig';
import { IResponsibilities } from '../Feature/Responsibilities';
import { FrontCacheDriver } from '../NativeDevice/Default/combinedDriver';
import { IFrontManagementDriver } from '../NativeDevice/Management/IManagementDriver';
import { IPropertyStorage } from '../Property/propertyStorage';
import { IPolymorphicSynchronizer } from '../Synchronization/PolymorphicSynchronizer/IPolymorphicSynchronizer';
import * as TestFramework from '../Test/TestFramework';
import { IWebWorkerFactory } from '../WebWorker/masterWebWorkerFactory';
import { IBundledApplet, NotifyBundledApplet } from './Applet/BundledApplet/bundledAppletActions';
import { IWeinreContainer } from './Device/Debug/deviceDebugHelper';
import { IFrontState } from './frontReducers';
export interface IFrontSagaOptions {
    publicKey: string;
    sessionIdKey: string;
    global: Window & IWeinreContainer;
    nativeDriver: FrontCacheDriver;
    managementDriver: IFrontManagementDriver;
    synchronizer: IPolymorphicSynchronizer;
    frontAppletPrefix: string;
    frontDisplayVersion: string;
    autoVerification: {
        organizationUid: string;
        deviceName?: string;
    } | undefined;
    webWorkerFactory: IWebWorkerFactory;
    applicationVersion: string;
    bundledApplet: null | IBundledApplet;
    responsibilities: IResponsibilities;
    /** Additional tests that should run, apart from the standard suite that always runs */
    frontExtraTests?: Promise<TestFramework.Describe>[];
    shortAppletFilesUrl?: boolean;
    logOfflineActions?: boolean;
}
export declare function frontSaga(defaultConfig: IConfig, { publicKey, sessionIdKey, global, nativeDriver, managementDriver, synchronizer, frontAppletPrefix, frontDisplayVersion, autoVerification, webWorkerFactory, applicationVersion, bundledApplet, responsibilities, frontExtraTests, shortAppletFilesUrl, logOfflineActions, }: IFrontSagaOptions, getState: () => IFrontState, propertyStorage: IPropertyStorage, dispatch: Dispatch<IFrontState>): Generator<import("redux-saga/effects").AllEffect<Iterator<any, any, undefined> | Generator<Promise<string> | import("redux-saga/effects").ForkEffect<any> | import("redux-saga").SagaIterator, void, {
    offlineActionsLimits: any;
} & string> | Generator<Promise<boolean> | import("redux-saga/effects").TakeEffect, void, boolean> | import("redux-saga/effects").PutEffect<NotifyBundledApplet> | Generator<Promise<void> | Promise<boolean> | Promise<never[]> | Generator<Promise<void> | import("redux-saga/effects").PutEffect<import("@signageos/actions/dist/Device/Telemetry/deviceTelemetryActions").UpdateDeviceTelemetryRecord<import("@signageos/common-types/dist/Device/Telemetry/DeviceTelemetryType").DeviceTelemetryType.FRONT_CAPABILITIES, {
    capable: import("@signageos/common-types/dist/Device/Capabilities/FrontCapability").FrontCapabilities[];
}>>, import("@signageos/actions/dist/Device/Telemetry/deviceTelemetryActions").UpdateDeviceTelemetryRecord<import("@signageos/common-types/dist/Device/Telemetry/DeviceTelemetryType").DeviceTelemetryType.FRONT_CAPABILITIES, {
    capable: import("@signageos/common-types/dist/Device/Capabilities/FrontCapability").FrontCapabilities[];
}>, import("../Application/IActionWithEmitter").default>, void, boolean & {
    capable: import("@signageos/common-types/dist/Device/Capabilities/FrontCapability").FrontCapabilities[];
}>>, void, unknown>;
