"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.frontReducer = void 0;
const redux_1 = require("redux");
const socketReducers_1 = require("./Socket/socketReducers");
const deviceReducers_1 = require("./Device/deviceReducers");
const organizationReducers_1 = require("./Organization/organizationReducers");
const deviceAuthenticationReducers_1 = require("./Device/deviceAuthenticationReducers");
const deviceVerificationReducers_1 = require("../Device/Verification/deviceVerificationReducers");
const deviceRemoteControlReducers_1 = require("./Device/RemoteControl/deviceRemoteControlReducers");
const networkReducers_1 = require("./Network/networkReducers");
const keyboardReducers_1 = require("./Input/keyboardReducers");
const authenticationReducers_1 = require("../Authentication/authenticationReducers");
const appletReducers_1 = require("./Applet/appletReducers");
const applicationReducers_1 = require("./Application/applicationReducers");
const deviceDebugReducers_1 = require("./Device/Debug/deviceDebugReducers");
const bundledAppletReducer_1 = require("./Applet/BundledApplet/bundledAppletReducer");
const licenseReducers_1 = require("./License/licenseReducers");
const deviceConnectReducers_1 = require("./Device/Connect/deviceConnectReducers");
exports.frontReducer = (0, redux_1.combineReducers)({
    applet: appletReducers_1.applet,
    bundledApplet: bundledAppletReducer_1.bundledApplet,
    authentication: authenticationReducers_1.authentication,
    socket: socketReducers_1.socket,
    device: deviceReducers_1.device,
    debug: deviceDebugReducers_1.debug,
    organization: organizationReducers_1.organization,
    deviceAuthentication: deviceAuthenticationReducers_1.deviceAuthentication,
    deviceVerification: deviceVerificationReducers_1.deviceVerification,
    deviceRemoteControl: deviceRemoteControlReducers_1.deviceRemoteControl,
    network: networkReducers_1.network,
    keyboard: keyboardReducers_1.keyboard,
    application: applicationReducers_1.application,
    license: licenseReducers_1.license,
    deviceConnect: deviceConnectReducers_1.deviceConnect,
});
//# sourceMappingURL=frontReducers.js.map