"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.LicenseOverlay = void 0;
const React = __importStar(require("react"));
const react_redux_1 = require("react-redux");
const licenseActions_1 = require("../../License/licenseActions");
const IConfig_1 = require("../../../Display/IConfig");
const LicenseOverlay_module_sass_1 = __importDefault(require("./LicenseOverlay.module.sass"));
class LicenseOverlay extends React.PureComponent {
    render() {
        const isOpen = this.props.subscriptionType === IConfig_1.SubscriptionType.open;
        const isNoSubscription = this.props.subscriptionType === null;
        const isHard = this.props.violationSeverity === licenseActions_1.ViolationSeverity.hard;
        const isSoft = this.props.violationSeverity === licenseActions_1.ViolationSeverity.soft;
        if (isOpen && isHard) {
            return React.createElement("div", { className: LicenseOverlay_module_sass_1.default.hard }, "License expired. Please contact your content provider for license renewal.");
        }
        else if (isOpen && isSoft) {
            return React.createElement("div", { className: LicenseOverlay_module_sass_1.default.soft }, "Your license will expire soon. Please contact your content provider for license renewal.");
        }
        else if (isNoSubscription && this.props.isBuiltUsingApplicationBuilder) {
            return React.createElement("div", { className: LicenseOverlay_module_sass_1.default.soft }, "Open license requires connection to provider server. See Terms & Conditions.");
        }
        else {
            return null;
        }
    }
}
exports.LicenseOverlay = LicenseOverlay;
exports.default = (0, react_redux_1.connect)((state) => ({
    violationSeverity: state.license.violationSeverity,
    subscriptionType: state.application.subscriptionType,
    isBuiltUsingApplicationBuilder: !!state.bundledApplet.bundledApplet,
}), (_dispatch) => ({}))(LicenseOverlay);
//# sourceMappingURL=LicenseOverlay.js.map