"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const React = __importStar(require("react"));
const react_1 = require("react");
const TimeInfo_module_sass_1 = __importDefault(require("./TimeInfo.module.sass"));
const dayjs_1 = __importDefault(require("dayjs"));
const DangerIcon_1 = require("../Application/Icons/DangerIcon");
function TimeInfo(props) {
    const [currentTimestamp, setCurrentTimestamp] = (0, react_1.useState)(props.timestamp);
    (0, react_1.useEffect)(() => {
        const interval = setInterval(() => {
            setCurrentTimestamp(Date.now());
        }, 5000);
        return () => clearInterval(interval);
    }, []);
    function showTimezone(timezone) {
        if (timezone) {
            return `(${timezone})`;
        }
        return null;
    }
    // We need to show a warning if the year is lower than 3 of actual year
    function validateYear(timestamp) {
        if ((0, dayjs_1.default)(timestamp).year() < Number(__CURRENT_YEAR__) - 3) {
            return React.createElement(DangerIcon_1.DangerIconSmall, null);
        }
    }
    // On initialization there might be no timestamp, we dont want to show anything in that case
    if (!currentTimestamp) {
        return null;
    }
    return (React.createElement("div", { className: TimeInfo_module_sass_1.default.timeInfo },
        React.createElement("span", { className: TimeInfo_module_sass_1.default.timeLabel }, "Time:"),
        React.createElement("span", null,
            (0, dayjs_1.default)(currentTimestamp).format('ddd, MMM DD, YYYY h:mm A'),
            " ",
            showTimezone(props.timezone),
            " ",
            validateYear(currentTimestamp))));
}
exports.default = TimeInfo;
//# sourceMappingURL=TimeInfo.js.map