import * as React from 'react';
import { IFile as IFileSystemFile } from '../../../NativeDevice/fileSystem';
export interface IProps {
    appletUid: string;
    checksum: string;
    uniqueHash?: string;
    binaryFile?: IFileSystemFile;
    nextAppletUid?: string;
    nextChecksum?: string;
    nextBinaryFile?: IFileSystemFile;
    onCreated(iframeElement: HTMLIFrameElement, appletUid: string): void;
    onStart(iframeElement: HTMLIFrameElement, appletUid: string): void;
    onRemoved(id: string): void;
}
export default class GaplessApplet extends React.PureComponent<IProps, {}> {
    private wrapper;
    private currentIframe;
    private nextIframe;
    componentDidMount(): void;
    componentDidUpdate(): void;
    render(): JSX.Element;
    private updateIframes;
    private createCurrentIframe;
    private createNextIframe;
    private makeNextIframeCurrent;
}
