"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ActiveApplet = void 0;
const React = __importStar(require("react"));
const react_redux_1 = require("react-redux");
const MainInfo_1 = __importDefault(require("../Info/MainInfo"));
const InfoProperty_1 = __importDefault(require("../Info/InfoProperty"));
const GaplessApplet_1 = __importDefault(require("./GaplessApplet"));
const appletTimingActions_1 = require("../../AppletTiming/appletTimingActions");
const DeviceInfo_1 = __importDefault(require("../Info/DeviceInfo"));
const SuccessIcon_1 = __importDefault(require("../Application/Icons/SuccessIcon"));
require("typeface-muli");
const TimeInfo_1 = __importDefault(require("../Info/TimeInfo"));
class ActiveApplet extends React.PureComponent {
    render() {
        if (this.props.appletIsMuted) {
            return (React.createElement("div", null,
                React.createElement(MainInfo_1.default, { title: 'Device name:', value: this.props.deviceName || '-- No Name --' }, "Content is muted because display is in POWER OFF state by timer settings")));
        }
        else if (this.props.appletMissing) {
            return (React.createElement("div", null,
                React.createElement(MainInfo_1.default, { title: 'Device name:', value: this.props.deviceName || '-- No Name --' }),
                React.createElement(TimeInfo_1.default, { timestamp: this.props.timestamp, timezone: this.props.timezone }),
                React.createElement(DeviceInfo_1.default, null,
                    React.createElement(InfoProperty_1.default, { title: 'Device:' }, this.getDeviceModel()),
                    React.createElement(InfoProperty_1.default, { title: 'System:' }, this.getSystemLabel()),
                    this.props.osVersion ? React.createElement(InfoProperty_1.default, { title: 'System Version:' }, this.props.osVersion) : null,
                    this.props.firmwareVersion ? React.createElement(InfoProperty_1.default, { title: 'Firmware Version:' }, this.props.firmwareVersion) : null,
                    this.props.serialNumber ? React.createElement(InfoProperty_1.default, { title: 'Serial Number:' }, this.props.serialNumber) : null,
                    React.createElement(InfoProperty_1.default, { title: 'Front Display Version:' }, this.props.frontDisplayVersion),
                    React.createElement(InfoProperty_1.default, { title: 'Application Version:' }, this.props.applicationVersion),
                    this.props.organizationTitle ? React.createElement(InfoProperty_1.default, { title: 'Organization:' }, this.props.organizationTitle) : null,
                    this.props.interfaceName ? React.createElement(InfoProperty_1.default, { title: 'Interface:' }, this.props.interfaceName) : null,
                    this.props.ipAddress ? React.createElement(InfoProperty_1.default, { title: 'Local IP Address:' }, this.props.ipAddress) : null,
                    this.props.wifiMacAddress ? React.createElement(InfoProperty_1.default, { title: 'Wifi Mac Address:' }, this.props.wifiMacAddress) : null,
                    this.props.ethernetMacAddress ? (React.createElement(InfoProperty_1.default, { title: 'Ethernet Mac Address:' }, this.props.ethernetMacAddress)) : null,
                    React.createElement(InfoProperty_1.default, { title: 'Status:' }, "No content applet configured")),
                React.createElement(SuccessIcon_1.default, null)));
        }
        else if (this.props.appletChecksum) {
            return (React.createElement(GaplessApplet_1.default, { appletUid: this.props.appletUid, checksum: this.props.appletChecksum, uniqueHash: this.props.appletUniqueHash, binaryFile: this.props.appletBinaryFile, nextAppletUid: this.props.nextAppletUid, nextChecksum: this.props.nextAppletChecksum, nextBinaryFile: this.props.nextAppletBinaryFile, onCreated: (iframeElement, appletUid) => this.props.onAppletIframeCreated(appletUid, iframeElement.id), onStart: (iframeElement, appletUid) => this.props.onAppletIframeStarted(appletUid, iframeElement.id), onRemoved: (iframeId) => this.props.onAppletIframeRemoved(iframeId) }));
        }
        else {
            return null;
        }
    }
    getSystemLabel() {
        return this.props.applicationType ? this.props.applicationType.toUpperCase() : 'UNKNOWN';
    }
    getDeviceModel() {
        return this.props.model ? this.props.model : 'Unknown';
    }
}
exports.ActiveApplet = ActiveApplet;
exports.default = (0, react_redux_1.connect)((state) => ({
    appletUid: state.applet.activeAppletUid,
    appletBinaryFile: state.applet.activeAppletBinaryFile,
    appletMissing: state.applet.activeAppletMissing,
    appletUniqueHash: state.applet.activeAppletUniqueHash,
    appletChecksum: state.applet.activeTimingChecksum,
    nextAppletUid: state.applet.nextApplet ? state.applet.nextApplet.uid : undefined,
    nextAppletBinaryFile: state.applet.nextApplet ? state.applet.nextApplet.appletBinaryFile : undefined,
    nextAppletChecksum: state.applet.nextApplet ? state.applet.nextApplet.timingChecksum : undefined,
    deviceName: state.device.deviceName,
    model: state.device.model,
    organizationTitle: state.organization.organizationTitle,
    appletIsMuted: state.applet.appletIsMuted,
    applicationType: state.device.applicationType,
    ethernetMacAddress: state.device.ethernetMacAddress,
    wifiMacAddress: state.device.wifiMacAddress,
    serialNumber: state.device.serialNumber,
    frontDisplayVersion: state.device.frontDisplayVersion,
    timezone: state.device.timezone,
    timestamp: state.device.timestamp,
    applicationVersion: state.device.applicationVersion,
    ipAddress: state.device.ipAddress,
    interfaceName: state.device.activeInterface,
    osVersion: state.device.osVersion,
    firmwareVersion: state.device.firmwareVersion,
}), (dispatch) => ({
    onAppletIframeCreated: (appletUid, appletIframeId) => dispatch({
        type: appletTimingActions_1.CreateAppletIframe,
        uid: appletUid,
        id: appletIframeId,
    }),
    onAppletIframeStarted: (appletUid, appletIframeId) => dispatch({
        type: appletTimingActions_1.StartAppletIframe,
        uid: appletUid,
        id: appletIframeId,
    }),
    onAppletIframeRemoved: (appletIframeId) => dispatch({
        type: appletTimingActions_1.RemoveAppletIframe,
        id: appletIframeId,
    }),
}))(ActiveApplet);
//# sourceMappingURL=ActiveApplet.js.map