"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const should_1 = __importDefault(require("../../Test/should"));
const t = __importStar(require("./../../Test/TestFramework"));
const deviceTestActions_1 = require("@signageos/actions/dist/Device/Test/deviceTestActions");
exports.default = (nativeDriver) => __awaiter(void 0, void 0, void 0, function* () {
    return t.describe(deviceTestActions_1.TestCase.CACHE, function* () {
        yield t.it('should test cacheGet, cacheGetAll, cacheDelete', () => __awaiter(this, void 0, void 0, function* () {
            const TEST_UID = 'Front.Cache.Test.Key';
            const TEST_CONTENT = 'Front.Cache.Test.Value';
            yield nativeDriver.cacheSave(TEST_UID, TEST_CONTENT);
            const loadedValue = yield nativeDriver.cacheGet(TEST_UID);
            (0, should_1.default)(loadedValue).equal(TEST_CONTENT);
            const allLoadedContentsWith = yield nativeDriver.cacheGetAll();
            (0, should_1.default)(Object.keys(allLoadedContentsWith)).containEql(TEST_UID);
            (0, should_1.default)(allLoadedContentsWith[TEST_UID]).equal(TEST_CONTENT);
            yield nativeDriver.cacheDelete(TEST_UID);
            const allLoadedContentsWithout = yield nativeDriver.cacheGetAll();
            (0, should_1.default)(Object.keys(allLoadedContentsWithout)).not.containEql(TEST_UID);
            try {
                yield nativeDriver.cacheGet(TEST_UID);
                (0, should_1.default)(true).be.false();
            }
            catch (e) {
                (0, should_1.default)(true).be.true();
            }
        }));
        yield t.it('should test cacheGetStorageInfo', () => __awaiter(this, void 0, void 0, function* () {
            const { totalSizeBytes, availableBytes, usedBytes } = yield nativeDriver.cacheGetStorageInfo();
            (0, should_1.default)(typeof totalSizeBytes).equal('number');
            (0, should_1.default)(typeof availableBytes).equal('number');
            (0, should_1.default)(typeof usedBytes).equal('number');
            (0, should_1.default)(totalSizeBytes).greaterThanOrEqual(availableBytes);
            (0, should_1.default)(availableBytes).greaterThanOrEqual(0);
            (0, should_1.default)(availableBytes + usedBytes).be.approximately(totalSizeBytes, totalSizeBytes / 50);
        }));
    });
});
//# sourceMappingURL=CacheTest.js.map