"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.systemLogsSaga = void 0;
const effects_1 = require("redux-saga/effects");
const applicationActions_1 = require("@signageos/actions/dist/Application/applicationActions");
const appletActions_1 = require("@signageos/actions/dist/Applet/appletActions");
const networkActions_1 = require("../Network/networkActions");
const systemLogActionFactory_1 = require("../../SystemLogs/systemLogActionFactory");
const activeAppletActions_1 = require("@signageos/actions/dist/Applet/activeAppletActions");
const systemLogs_1 = require("@signageos/common-types/dist/Device/SystemLogs/systemLogs");
function* systemLogsSaga(getManagementDriver) {
    yield (0, effects_1.takeEvery)(applicationActions_1.StartApplication, function* () {
        yield (0, effects_1.put)((0, systemLogActionFactory_1.createSystemLogAction)({
            type: systemLogs_1.ApplicationStarted,
            startedAt: new Date(),
        }));
    });
    yield (0, effects_1.takeEvery)(appletActions_1.UpdateActiveAppletBinary, function* (action) {
        yield (0, effects_1.put)((0, systemLogActionFactory_1.createSystemLogAction)({
            type: systemLogs_1.AppletStarted,
            appletUid: action.activeAppletUid,
            appletVersion: action.activeAppletVersion,
        }));
    });
    yield (0, effects_1.takeEvery)(networkActions_1.NetworkStatusChanged, function* () {
        const networkStatus = yield getManagementDriver().network.listInterfaces();
        if (networkStatus) {
            yield (0, effects_1.put)((0, systemLogActionFactory_1.createSystemLogAction)({
                type: systemLogs_1.NetworkChanged,
                data: networkStatus,
            }));
        }
    });
    yield (0, effects_1.takeEvery)(activeAppletActions_1.AppletPing, function* (action) {
        yield (0, effects_1.put)((0, systemLogActionFactory_1.createSystemLogAction)({
            type: systemLogs_1.AppletRunning,
            appletUid: action.appletUid,
        }));
    });
}
exports.systemLogsSaga = systemLogsSaga;
//# sourceMappingURL=systemLogsSagas.js.map