"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.reportDevicePinChangedSaga = exports.generateControlPinSaga = exports.controlEnablingSaga = exports.putDevicePinChanged = void 0;
const socketActionCreator_1 = require("../../Socket/socketActionCreator");
const effects_1 = require("redux-saga/effects");
const keyActions_1 = require("@signageos/actions/dist/Input/keyActions");
const authenticationActions_1 = require("@signageos/actions/dist/Authentication/authenticationActions");
const deviceInputActions_1 = require("@signageos/actions/dist/Device/Input/deviceInputActions");
const deviceRemoteControlActions_1 = require("../../Device/RemoteControl/deviceRemoteControlActions");
const KeyCode_1 = require("../../NativeDevice/Input/KeyCode");
const numericSequence_1 = require("../Input/numericSequence");
const Responsibility_1 = __importDefault(require("../../Feature/Responsibility"));
const security_1 = require("./security");
const applicationActions_1 = require("../../Application/applicationActions");
const redux_saga_1 = require("redux-saga");
const dependencyInjection_1 = require("../../DI/dependencyInjection");
const responsible_1 = require("../../Feature/responsible");
const processCallback_1 = __importDefault(require("../../Util/processCallback"));
// Currently this action is both reduced in front and sent to server.
// Ideally, we would split that and send to server based on responsibility and subscription type.
const putDevicePinChanged = (pin) => (0, effects_1.put)({
    type: deviceInputActions_1.DevicePinChanged,
    pin,
});
exports.putDevicePinChanged = putDevicePinChanged;
// TODO remove this and add this option to OSD
// Enabling/disabling remote control requires a Responsibility, same as management.
exports.controlEnablingSaga = (0, responsible_1.whenResponsible)(Responsibility_1.default.KIOSK, (0, dependencyInjection_1.withDependencies)(['frontDriver'], function* ({ frontDriver }) {
    const { security } = frontDriver;
    yield (0, effects_1.takeEvery)(keyActions_1.HandleKeySequence, function* (handleKeySequence) {
        try {
            const characterSequence = (0, numericSequence_1.getNumericCode)(handleKeySequence.sequence);
            if (!characterSequence) {
                return;
            }
            const isPinOk = yield security.verifyPin(characterSequence);
            if (isPinOk) {
                yield remoteControlSetEnabled(frontDriver, true);
            }
        }
        catch (error) {
            console.error('controlEnablingSaga:keySequence', error);
        }
    });
    yield (0, effects_1.takeEvery)(keyActions_1.HandleKeyUp, function* (handleKeyUp) {
        try {
            const isSecure = yield security.isSecure();
            if (!isSecure) {
                // Don't lock the device if there's no PIN.
                return;
            }
            if (handleKeyUp.keyCode === KeyCode_1.KeyCode[KeyCode_1.KeyCode.LOCK]) {
                yield remoteControlSetEnabled(frontDriver, false);
            }
        }
        catch (error) {
            console.error('controlEnablingSaga:keyUp', error);
        }
    });
}));
exports.generateControlPinSaga = (0, responsible_1.whenResponsible)(Responsibility_1.default.KIOSK, (0, dependencyInjection_1.withDependencies)(['frontDriver'], function* ({ frontDriver }) {
    const { security } = frontDriver;
    yield (0, effects_1.fork)(function* () {
        try {
            yield ensurePin(security);
        }
        catch (error) {
            console.error('generateControlPinSaga:ensurePin', error);
        }
    });
    yield (0, socketActionCreator_1.bindAndTakeEvery)(authenticationActions_1.AuthenticationSucceed, function* () {
        try {
            yield ensurePin(security);
            if (yield security.verifyPin(security_1.DEFAULT_OPEN_PIN_CODE)) {
                // Authenticated (connected) device will always create unique secret PIN code
                const pin = generateRandomPinCode();
                yield security.setPin(pin);
                yield (0, exports.putDevicePinChanged)(pin);
            }
        }
        catch (error) {
            console.error('generateControlPinSaga', error);
        }
    });
}));
exports.reportDevicePinChangedSaga = (0, dependencyInjection_1.withDependencies)(['frontDriver'], function* ({ frontDriver }) {
    const { security } = frontDriver;
    const pinSetChannel = (0, redux_saga_1.channel)(redux_saga_1.buffers.none());
    yield (0, effects_1.takeEvery)(pinSetChannel, function* () {
        try {
            const pin = yield security.getPin();
            yield (0, exports.putDevicePinChanged)(pin);
        }
        catch (error) {
            console.error('reportDevicePinChangedSaga:devicePinChanged', error);
        }
    });
    const listener = () => pinSetChannel.put({}); // Ping channel every time PIN changes.
    const removeListener = security.onPinSet(listener);
    try {
        pinSetChannel.put({}); // Extra ping on app start with initial state.
        (0, effects_1.take)(applicationActions_1.StopApplication);
    }
    finally {
        removeListener();
    }
});
function ensurePin(security) {
    return __awaiter(this, void 0, void 0, function* () {
        const isSecure = yield security.isSecure();
        if (!isSecure) {
            yield security.setPin(security_1.DEFAULT_OPEN_PIN_CODE);
        }
    });
}
function generateRandomPinCode() {
    return Math.floor(Math.random() * 1e4)
        .toString()
        .padStart(4, '0');
}
function* remoteControlSetEnabled(nativeDriver, enabled) {
    const finalizeCallback = yield nativeDriver.remoteControlSetEnabled(enabled);
    (0, processCallback_1.default)(finalizeCallback);
    yield (0, effects_1.put)({
        type: deviceRemoteControlActions_1.DeviceRemoteControlSet,
        enabled,
    });
}
//# sourceMappingURL=controlEnablingSagas.js.map