"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const Property_1 = __importDefault(require("../../Property/Property"));
class PinPropertyStorage {
    constructor(propertyStorage) {
        this.propertyStorage = propertyStorage;
    }
    /**
     * @returns Whether this storage has ever persisted any data.
     */
    hasPersistedData() {
        return __awaiter(this, void 0, void 0, function* () {
            const pin = yield this.propertyStorage.getValueOrDefault(Property_1.default.PIN, undefined);
            return typeof pin !== 'undefined';
        });
    }
    loadPin() {
        return __awaiter(this, void 0, void 0, function* () {
            return yield this.propertyStorage.getValueOrDefault(Property_1.default.PIN, null);
        });
    }
    savePin(pin) {
        return __awaiter(this, void 0, void 0, function* () {
            return yield this.propertyStorage.setValue(Property_1.default.PIN, pin);
        });
    }
}
exports.default = PinPropertyStorage;
//# sourceMappingURL=PinPropertyStorage.js.map