"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const events_1 = require("events");
class DefaultSecurity {
    constructor(storage, setPinDelegate) {
        this.storage = storage;
        this.setPinDelegate = setPinDelegate;
        this.events = new events_1.EventEmitter();
    }
    isSecure() {
        return __awaiter(this, void 0, void 0, function* () {
            return (yield this.getPin()) !== '';
        });
    }
    verifyPin(pin) {
        return __awaiter(this, void 0, void 0, function* () {
            const currentPin = yield this.getPin();
            if (currentPin !== '' && currentPin === pin) {
                return true;
            }
            // PIN doesn't match or no PIN is set.
            return false;
        });
    }
    getPin() {
        var _a;
        return __awaiter(this, void 0, void 0, function* () {
            return (_a = (yield this.storage.loadPin())) !== null && _a !== void 0 ? _a : '';
        });
    }
    setPin(newPin) {
        return __awaiter(this, void 0, void 0, function* () {
            const oldPin = yield this.storage.loadPin();
            yield this.storage.savePin(newPin);
            try {
                yield this.setPinDelegate(newPin);
                this.events.emit('pin_set');
            }
            catch (e) {
                // Restore old PIN on failure.
                yield this.storage.savePin(oldPin);
                throw e;
            }
        });
    }
    onPinSet(listener) {
        this.events.addListener('pin_set', listener);
        return () => this.events.removeListener('pin_set', listener);
    }
}
exports.default = DefaultSecurity;
//# sourceMappingURL=DefaultSecurity.js.map