"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.bindNumericKeyboardSaga = void 0;
const lodash_1 = require("lodash");
const effects_1 = require("redux-saga/effects");
const keyActions_1 = require("@signageos/actions/dist/Input/keyActions");
const motionActions_1 = require("@signageos/actions/dist/Input/motionActions");
const keyboardActions_1 = require("@signageos/actions/dist/Input/keyboardActions");
const GestureAction_1 = __importDefault(require("../../NativeDevice/Input/GestureAction"));
const KeyCode_1 = require("../../NativeDevice/Input/KeyCode");
const wait_1 = __importDefault(require("@signageos/lib/dist/Timer/wait"));
const SHOW_KEYBOARD_SEQUENCE = [
    GestureAction_1.default[GestureAction_1.default.DOUBLE_TAP],
    GestureAction_1.default[GestureAction_1.default.DOUBLE_TAP],
    GestureAction_1.default[GestureAction_1.default.DOUBLE_TAP],
    GestureAction_1.default[GestureAction_1.default.DOUBLE_TAP],
    GestureAction_1.default[GestureAction_1.default.DOUBLE_TAP],
    GestureAction_1.default[GestureAction_1.default.DOUBLE_TAP],
    GestureAction_1.default[GestureAction_1.default.DOUBLE_TAP],
    GestureAction_1.default[GestureAction_1.default.DOUBLE_TAP],
    GestureAction_1.default[GestureAction_1.default.DOUBLE_TAP],
    GestureAction_1.default[GestureAction_1.default.DOUBLE_TAP],
];
function* bindNumericKeyboardSaga() {
    let lastMotionSequence = [];
    yield (0, effects_1.takeEvery)(motionActions_1.HandleMotionSequence, function* (motionSequence) {
        try {
            lastMotionSequence = (0, lodash_1.takeRight)(motionSequence.sequence.filter((gestureAction) => SHOW_KEYBOARD_SEQUENCE.indexOf(gestureAction) !== -1), SHOW_KEYBOARD_SEQUENCE.length);
        }
        catch (error) {
            console.error('bindPinKeyboardSaga motion sequence', error);
        }
    });
    yield (0, effects_1.takeEvery)(keyActions_1.HandleKeyUp, function* (handleKeyUp) {
        try {
            if (handleKeyUp.keyCode === KeyCode_1.KeyCode[KeyCode_1.KeyCode.VOLUME_UP] && lastMotionSequence.join() === SHOW_KEYBOARD_SEQUENCE.join()) {
                yield (0, effects_1.put)({
                    type: keyboardActions_1.ShowNumericKeyboard,
                });
                yield (0, wait_1.default)(20e3);
                yield (0, effects_1.put)({
                    type: keyboardActions_1.HideNumericKeyboard,
                });
            }
        }
        catch (error) {
            console.error('bindPinKeyboardSaga confirm key', error);
        }
    });
}
exports.bindNumericKeyboardSaga = bindNumericKeyboardSaga;
//# sourceMappingURL=softwareKeyboardSagas.js.map