"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.keySequenceSaga = exports.keyUpSaga = void 0;
const effects_1 = require("redux-saga/effects");
const channels_1 = require("../../ReduxSaga/channels");
const applicationActions_1 = require("@signageos/actions/dist/Application/applicationActions");
const keyActions_1 = require("@signageos/actions/dist/Input/keyActions");
const KeyCode_1 = require("../../NativeDevice/Input/KeyCode");
function* keyUpSaga(getNativeDriver) {
    yield (0, effects_1.takeEvery)(applicationActions_1.StartApplication, function* () {
        try {
            const nativeDriver = getNativeDriver();
            const keyUpChannel = (0, channels_1.createChannel)((putHere) => nativeDriver.bindKeyUp((keyUpEvent) => putHere(keyUpEvent)));
            yield (0, channels_1.takeEvery)(keyUpChannel, function* (keyUpEvent) {
                yield (0, effects_1.put)({
                    type: keyActions_1.HandleKeyUp,
                    keyCode: KeyCode_1.KeyCode[keyUpEvent.keyCode],
                });
            });
        }
        catch (error) {
            console.error('keyUpSaga', error);
        }
    });
}
exports.keyUpSaga = keyUpSaga;
function* keySequenceSaga(window) {
    let cleanSequenceTimeout;
    let pressedSequence = [];
    yield (0, effects_1.takeEvery)(keyActions_1.HandleKeyUp, function* (handleKeyUp) {
        try {
            window.clearTimeout(cleanSequenceTimeout);
            yield (0, effects_1.fork)(function* () {
                yield new Promise((resolve) => {
                    cleanSequenceTimeout = window.setTimeout(() => resolve(), 4 * 1e3);
                });
                pressedSequence = [];
                yield (0, effects_1.put)({
                    type: keyActions_1.HandleKeySequence,
                    sequence: [...pressedSequence],
                });
            });
            if (handleKeyUp.keyCode !== undefined) {
                pressedSequence.push(handleKeyUp.keyCode);
                yield (0, effects_1.put)({
                    type: keyActions_1.HandleKeySequence,
                    sequence: [...pressedSequence],
                });
            }
        }
        catch (error) {
            console.error('keySequenceSaga', error);
        }
    });
}
exports.keySequenceSaga = keySequenceSaga;
//# sourceMappingURL=keySagas.js.map