"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.notifyFirmwareVersion = exports.notifyFrontCapabilities = exports.getDeviceLocationAndTags = exports.updateOrganizationTags = exports.updateDeviceLocation = exports.notifyDeviceApplicationVersion = exports.notifyDeviceSaga = exports.updateTitle = void 0;
const applicationActions_1 = require("@signageos/actions/dist/Application/applicationActions");
const deviceTelemetryActions_1 = require("@signageos/actions/dist/Device/Telemetry/deviceTelemetryActions");
const deviceActions_1 = require("@signageos/actions/dist/Device/deviceActions");
const locationActions_1 = require("@signageos/actions/dist/Location/locationActions");
const organizationTagActions_1 = require("@signageos/actions/dist/Organization/Tag/organizationTagActions");
const organizationActions_1 = require("@signageos/actions/dist/Organization/organizationActions");
const DeviceTelemetryType_1 = require("@signageos/common-types/dist/Device/Telemetry/DeviceTelemetryType");
const lodash_1 = require("lodash");
const effects_1 = require("redux-saga/effects");
const deviceSagas_1 = require("../../Device/deviceSagas");
const FrontCapability_1 = __importDefault(require("../../NativeDevice/Front/FrontCapability"));
const Property_1 = __importDefault(require("../../Property/Property"));
const socketActionCreator_1 = require("../../Socket/socketActionCreator");
const socketActionDeliverHelper_1 = require("../../Socket/socketActionDeliverHelper");
const deviceActions_2 = require("./deviceActions");
function* updateTitle(window) {
    yield (0, socketActionCreator_1.bindAndTakeEvery)(deviceActions_1.UpdateDeviceName, function* (action) {
        try {
            const titleElement = window.document.head.getElementsByTagName('title')[0];
            titleElement.innerHTML = action.deviceName;
        }
        catch (error) {
            console.error('updateTitle failed', error);
        }
    });
    // For displaying organization in default screen
    yield (0, socketActionCreator_1.bindWhenPlatform)(organizationActions_1.UpdateOrganization);
}
exports.updateTitle = updateTitle;
function* notifyDeviceSaga(getNativeDriver) {
    yield (0, effects_1.takeEvery)(applicationActions_1.StartApplication, deviceSagas_1.notifyDeviceInfo, getNativeDriver);
    yield (0, effects_1.takeEvery)(applicationActions_1.StartApplication, deviceSagas_1.notifyDeviceProxyInfo, getNativeDriver);
    yield (0, effects_1.takeEvery)(applicationActions_1.StartApplication, (0, exports.notifyFirmwareVersion)(getNativeDriver));
}
exports.notifyDeviceSaga = notifyDeviceSaga;
function* notifyDeviceApplicationVersion(getNativeDriver, applicationVersion) {
    yield (0, effects_1.takeEvery)(applicationActions_1.StartApplication, deviceSagas_1.notifyDeviceApplicationVersionCommon, getNativeDriver, applicationVersion);
}
exports.notifyDeviceApplicationVersion = notifyDeviceApplicationVersion;
function* updateDeviceLocation(propertyStorage) {
    yield (0, socketActionCreator_1.bindAndTakeEvery)(locationActions_1.UpdateLocation, function* (action) {
        yield propertyStorage.setValue(Property_1.default.DEVICE_LOCATION, action.location);
    });
    yield (0, effects_1.takeEvery)(applicationActions_1.StartApplication, function* () {
        const storedLocation = yield propertyStorage.getValueOrDefault(Property_1.default.DEVICE_LOCATION, null);
        yield (0, effects_1.put)({
            type: locationActions_1.UpdateLocation,
            location: storedLocation,
        });
    });
}
exports.updateDeviceLocation = updateDeviceLocation;
function* updateOrganizationTags(propertyStorage) {
    yield (0, socketActionCreator_1.bindAndTakeEvery)(organizationTagActions_1.UpdateOrganizationTags, function* (action) {
        yield propertyStorage.setValue(Property_1.default.DEVICE_ORGANIZATION_TAGS, action.tags);
    });
    yield (0, effects_1.takeEvery)(applicationActions_1.StartApplication, function* () {
        const storedOrganizationTags = yield propertyStorage.getValueOrDefault(Property_1.default.DEVICE_ORGANIZATION_TAGS, []);
        yield (0, effects_1.put)({
            type: organizationTagActions_1.UpdateOrganizationTags,
            tags: storedOrganizationTags,
        });
    });
}
exports.updateOrganizationTags = updateOrganizationTags;
/**
 * Update device location and organization tags in local storage
 * which can be later retrieved by the JS API.
 */
function* getDeviceLocationAndTags() {
    yield (0, effects_1.takeEvery)(applicationActions_1.StartApplication, function* () {
        yield (0, effects_1.put)({ type: locationActions_1.GetLocation });
        yield (0, effects_1.put)({ type: organizationTagActions_1.GetOrganizationTags });
    });
}
exports.getDeviceLocationAndTags = getDeviceLocationAndTags;
function* notifyFrontCapabilities(propertyStorage, getNativeDriver) {
    let supportedCapabilities = [];
    try {
        const nativeDriver = getNativeDriver();
        for (const capability of Object.values(FrontCapability_1.default)) {
            const supported = yield nativeDriver.frontSupports(capability);
            if (supported) {
                supportedCapabilities.push(capability);
            }
        }
        const isCapable = {
            capable: supportedCapabilities,
        };
        const lastUpdated = yield propertyStorage.getValueOrDefault(Property_1.default.LATEST_REPORTED_SETTINGS_FRONT_CAPABILITIES, []);
        if (!(0, lodash_1.isEqual)(lastUpdated, isCapable)) {
            yield propertyStorage.setValue(Property_1.default.LATEST_REPORTED_SETTINGS_FRONT_CAPABILITIES, isCapable);
            yield (0, socketActionDeliverHelper_1.deliver)({
                type: deviceTelemetryActions_1.UpdateDeviceTelemetryRecord,
                name: DeviceTelemetryType_1.DeviceTelemetryType.FRONT_CAPABILITIES,
                data: isCapable,
            });
        }
    }
    catch (error) {
        console.error('notifyCapabilities failed front', error);
    }
}
exports.notifyFrontCapabilities = notifyFrontCapabilities;
const notifyFirmwareVersion = (getManagementDriver) => {
    return function* () {
        try {
            const firmwareVersion = yield getManagementDriver().firmwareGetVersion();
            yield (0, effects_1.put)({ type: deviceActions_2.UpdateDisplayFirmwareVersion, version: firmwareVersion });
        }
        catch (error) {
            console.error('notifyFirmwareVersion failed', error);
        }
    };
};
exports.notifyFirmwareVersion = notifyFirmwareVersion;
//# sourceMappingURL=deviceSagas.js.map