"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.device = void 0;
const deviceActions_1 = require("@signageos/actions/dist/Device/deviceActions");
const deviceActions_2 = require("../../Device/deviceActions");
const locationActions_1 = require("@signageos/actions/dist/Location/locationActions");
const organizationTagActions_1 = require("@signageos/actions/dist/Organization/Tag/organizationTagActions");
const deviceDateTimeActions_1 = require("@signageos/actions/dist/Device/DateTime/deviceDateTimeActions");
const deviceFrontDisplayActions_1 = require("@signageos/actions/dist/Device/FrontDisplay/deviceFrontDisplayActions");
const deviceApplicationActions_1 = require("@signageos/actions/dist/Device/Application/deviceApplicationActions");
const deviceInputActions_1 = require("@signageos/actions/dist/Device/Input/deviceInputActions");
const networkActions_1 = require("../Network/networkActions");
const deviceActions_3 = require("./deviceActions");
const initialState = {
    failReason: null,
    applicationType: null,
    osVersion: null,
    model: null,
    deviceName: null,
    debugOn: false,
    ethernetMacAddress: null,
    wifiMacAddress: null,
    isSerialNumberSupported: false,
    serialNumber: null,
    pinCode: null,
    frontDisplayVersion: null,
    applicationVersion: null,
    timezone: null,
    timestamp: null,
    ipAddress: null,
    interfaceName: null,
    activeInterface: null,
    location: null,
    organizationTags: [],
    firmwareVersion: null,
};
function device(state = initialState, action) {
    switch (action.type) {
        case deviceActions_1.DeviceRegistrationFailed:
            return Object.assign(Object.assign({}, state), { failReason: action.reason });
        case deviceActions_1.UpdateDeviceInfo:
            return Object.assign(Object.assign({}, state), action);
        case deviceActions_2.UpdateSerialNumberSupport:
            return Object.assign(Object.assign({}, state), { isSerialNumberSupported: action.supported });
        case deviceInputActions_1.DevicePinChanged:
            return Object.assign(Object.assign({}, state), { pinCode: action.pin });
        case deviceActions_1.UpdateDeviceName:
            return Object.assign(Object.assign({}, state), { deviceName: action.deviceName });
        case deviceDateTimeActions_1.NotifyCurrentTime:
            return Object.assign(Object.assign({}, state), { timezone: action.timezone, timestamp: action.timestamp });
        case deviceFrontDisplayActions_1.NotifyDeviceFrontDisplayVersion:
            return Object.assign(Object.assign({}, state), { frontDisplayVersion: action.version });
        case deviceApplicationActions_1.NotifyDeviceApplicationVersion:
            return Object.assign(Object.assign({}, state), { applicationVersion: action.applicationVersion });
        case locationActions_1.UpdateLocation:
            return Object.assign(Object.assign({}, state), { location: action.location });
        case organizationTagActions_1.UpdateOrganizationTags:
            return Object.assign(Object.assign({}, state), { organizationTags: action.tags });
        case deviceActions_3.UpdateDisplayFirmwareVersion:
            return Object.assign(Object.assign({}, state), { firmwareVersion: action.version });
        case networkActions_1.NetworkStatusChanged:
            const activeInterface = action.data.find((network) => network.localAddress !== undefined);
            if (!activeInterface) {
                return Object.assign(Object.assign({}, state), { activeInterface: null, ipAddress: null, interfaceName: null });
            }
            switch (activeInterface.type) {
                case 'ethernet':
                    return Object.assign(Object.assign({}, state), { activeInterface: activeInterface.name || null, ipAddress: activeInterface.localAddress || null, ethernetMacAddress: activeInterface.macAddress || null });
                case 'wifi':
                    return Object.assign(Object.assign({}, state), { activeInterface: activeInterface.name || null, ipAddress: activeInterface.localAddress || null, wifiMacAddress: activeInterface.macAddress || null });
                case 'vpn':
                    return Object.assign(Object.assign({}, state), { activeInterface: activeInterface.name || null, ipAddress: activeInterface.localAddress || null });
                default:
                    return state;
            }
        default:
            return state;
    }
}
exports.device = device;
//# sourceMappingURL=deviceReducers.js.map