import RegisterFailReason from '@signageos/actions/dist/Device/RegisterFailReason';
import { DeviceRegistrationFailed, UpdateDeviceName, UpdateDeviceInfo } from '@signageos/actions/dist/Device/deviceActions';
import { UpdateSerialNumberSupport } from '../../Device/deviceActions';
import { UpdateLocation, ILocation } from '@signageos/actions/dist/Location/locationActions';
import { IOrganizationTag, UpdateOrganizationTags } from '@signageos/actions/dist/Organization/Tag/organizationTagActions';
import { SetDeviceDebugSettings } from '@signageos/actions/dist/Device/Debug/deviceDebugActions';
import { NotifyCurrentTime } from '@signageos/actions/dist/Device/DateTime/deviceDateTimeActions';
import { NotifyDeviceFrontDisplayVersion } from '@signageos/actions/dist/Device/FrontDisplay/deviceFrontDisplayActions';
import { NotifyDeviceApplicationVersion } from '@signageos/actions/dist/Device/Application/deviceApplicationActions';
import { DevicePinChanged } from '@signageos/actions/dist/Device/Input/deviceInputActions';
import { ReadDeviceDebugSettings } from './Debug/deviceDebugLocalActions';
import { NetworkStatusChanged } from '../Network/networkActions';
import { UpdateDisplayFirmwareVersion } from './deviceActions';
export interface IDeviceState {
    failReason: RegisterFailReason | null;
    applicationType: string | null;
    osVersion: string | null;
    model: string | null;
    deviceName: string | null;
    debugOn: boolean;
    ethernetMacAddress: string | null;
    wifiMacAddress: string | null;
    isSerialNumberSupported: boolean;
    serialNumber: string | null;
    pinCode: string | null;
    frontDisplayVersion: string | null;
    applicationVersion: string | null;
    timezone: string | null;
    timestamp: number | null;
    ipAddress: string | null;
    interfaceName: string | null;
    activeInterface: string | null;
    firmwareVersion: string | null;
    location: ILocation | null;
    organizationTags: IOrganizationTag[];
}
export declare function device(state: IDeviceState | undefined, action: DeviceRegistrationFailed | UpdateDeviceInfo | UpdateSerialNumberSupport | DevicePinChanged | UpdateDeviceName | NotifyCurrentTime | NotifyDeviceFrontDisplayVersion | NotifyDeviceApplicationVersion | SetDeviceDebugSettings | ReadDeviceDebugSettings | UpdateLocation | UpdateOrganizationTags | NetworkStatusChanged | UpdateDisplayFirmwareVersion): IDeviceState;
