"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.appletTimerChecking = exports.displayTimerChecking = void 0;
const effects_1 = require("redux-saga/effects");
const devicePowerActionActions_1 = require("../Power/devicePowerActionActions");
const debug_1 = __importDefault(require("debug"));
const IProprietaryTimerResolver_1 = require("../../../Timer/IProprietaryTimerResolver");
const redux_saga_1 = require("redux-saga");
const Responsibility_1 = __importDefault(require("../../../Feature/Responsibility"));
const debug = (0, debug_1.default)('@signageos/front-display:Front:Device:Timer:timerControllerSagas');
const timerCheckingChannel = (0, redux_saga_1.channel)();
const timerCheckingChannelApplet = (0, redux_saga_1.channel)();
function* displayTimerChecking(responsibilities, timersManager) {
    if (!responsibilities.has(Responsibility_1.default.TIMERS)) {
        return;
    }
    debug('timerChecking start');
    timersManager
        .on(IProprietaryTimerResolver_1.DisplayEvent.POWER_ON, () => {
        debug('turning display on');
        timerCheckingChannel.put({
            type: devicePowerActionActions_1.TriggerDisplayPowerOn,
        });
    })
        .on(IProprietaryTimerResolver_1.DisplayEvent.POWER_OFF, () => {
        debug('turning display off');
        timerCheckingChannel.put({
            type: devicePowerActionActions_1.TriggerDisplayPowerOff,
        });
    });
    // TODO Clean up timersManager when the saga is done.
    yield (0, effects_1.takeEvery)(timerCheckingChannel, function* (action) {
        yield (0, effects_1.put)(action);
    });
}
exports.displayTimerChecking = displayTimerChecking;
function* appletTimerChecking(responsibilities, timersManager) {
    if (!responsibilities.has(Responsibility_1.default.TIMERS)) {
        return;
    }
    timersManager
        .on(IProprietaryTimerResolver_1.TimerEvent.TIMER_ON, () => {
        debug('enabling applet');
        timerCheckingChannelApplet.put({
            type: devicePowerActionActions_1.TriggerAppletOn,
        });
    })
        .on(IProprietaryTimerResolver_1.TimerEvent.TIMER_OFF, () => {
        debug('disabling applet');
        timerCheckingChannelApplet.put({
            type: devicePowerActionActions_1.TriggerAppletOff,
        });
    });
    // TODO Clean up timersManager when the saga is done.
    yield (0, effects_1.takeEvery)(timerCheckingChannelApplet, function* (action) {
        yield (0, effects_1.put)(action);
    });
}
exports.appletTimerChecking = appletTimerChecking;
//# sourceMappingURL=timerControllerSagas.js.map