"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.startupDeviceRemoteControlSettingsSaga = void 0;
const socketActionCreator_1 = require("../../../Socket/socketActionCreator");
const effects_1 = require("redux-saga/effects");
const applicationActions_1 = require("@signageos/actions/dist/Application/applicationActions");
const authenticationActions_1 = require("@signageos/actions/dist/Authentication/authenticationActions");
const deviceRemoteControlActions_1 = require("../../../Device/RemoteControl/deviceRemoteControlActions");
const debug_1 = __importDefault(require("debug"));
const debug = (0, debug_1.default)('@signageos/front-display:Front:Device:RemoteControl:deviceRemoteControlSagas');
function* startupDeviceRemoteControlSettingsSaga(getNativeDriver) {
    yield (0, socketActionCreator_1.bindAndTakeEvery)(authenticationActions_1.AuthenticationSucceed, startupDeviceRemoteControlSettings, getNativeDriver);
    yield (0, effects_1.takeEvery)(applicationActions_1.StartApplication, startupDeviceRemoteControlSettings, getNativeDriver);
}
exports.startupDeviceRemoteControlSettingsSaga = startupDeviceRemoteControlSettingsSaga;
function* startupDeviceRemoteControlSettings(getNativeDriver) {
    try {
        const nativeDriver = getNativeDriver();
        const enabled = yield nativeDriver.remoteControlIsEnabled();
        yield (0, effects_1.put)({
            type: deviceRemoteControlActions_1.DeviceRemoteControlSet,
            enabled,
        });
    }
    catch (error) {
        debug("Couldn't determine if the remote control is enabled during startup", error);
    }
}
//# sourceMappingURL=deviceRemoteControlSagas.js.map