"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.performAppletRefresh = exports.deviceAppletDisablingRestoresActiveApplet = exports.devicePerformScheduledPowerAction = exports.devicePerformPowerAction = void 0;
const appletActions_1 = require("@signageos/actions/dist/Applet/appletActions");
const PowerActionType_1 = __importDefault(require("@signageos/actions/dist/Device/Power/PowerActionType"));
const devicePowerActions_1 = require("@signageos/actions/dist/Device/Power/devicePowerActions");
const generator_1 = require("@signageos/lib/dist/Hash/generator");
const lodash_1 = __importDefault(require("lodash"));
const effects_1 = require("redux-saga/effects");
const combinedDriver_1 = require("../../../NativeDevice/Default/combinedDriver");
const Property_1 = __importDefault(require("../../../Property/Property"));
const socketActionCreator_1 = require("../../../Socket/socketActionCreator");
const socketActionDeliverHelper_1 = require("../../../Socket/socketActionDeliverHelper");
const activeAppletActions_1 = require("../../Applet/activeAppletActions");
const devicePowerActionActions_1 = require("./devicePowerActionActions");
function* devicePerformPowerAction(getNativeDriver, propertyStorage, offlineCache) {
    yield (0, socketActionCreator_1.takeEveryAndBindWhenPlatform)(devicePowerActions_1.PerformPowerAction, function* ({ powerType, id }) {
        const { frontDriver } = (0, combinedDriver_1.normalizeFrontCacheDriver)(getNativeDriver());
        const deviceUid = yield frontDriver.getDeviceUid();
        try {
            yield* (0, socketActionDeliverHelper_1.deliver)({
                type: devicePowerActions_1.PerformPowerActionSucceed,
                id,
                deviceUid,
            });
            const powerActionProcessed = yield* performPowerAction(getNativeDriver, propertyStorage, offlineCache, powerType);
            if (!powerActionProcessed) {
                return;
            }
        }
        catch (error) {
            console.error(error);
            yield (0, effects_1.put)({
                type: devicePowerActions_1.PerformPowerActionFailed,
                id,
                deviceUid,
            });
        }
    });
}
exports.devicePerformPowerAction = devicePerformPowerAction;
function* devicePerformScheduledPowerAction(getNativeDriver, propertyStorage, offlineCache) {
    yield (0, effects_1.takeEvery)(devicePowerActionActions_1.PerformScheduledPowerAction, function* ({ powerType }) {
        try {
            yield performPowerAction(getNativeDriver, propertyStorage, offlineCache, powerType);
        }
        catch (error) {
            console.error('devicePerformScheduledPowerAction failed', error);
        }
    });
}
exports.devicePerformScheduledPowerAction = devicePerformScheduledPowerAction;
function* deviceAppletDisablingRestoresActiveApplet() {
    yield (0, effects_1.takeEvery)(devicePowerActionActions_1.TriggerAppletOn, function* () {
        try {
            yield (0, effects_1.put)({ type: appletActions_1.UpdateActiveAppletUniqueHash, hash: (0, generator_1.generateUniqueHash)() });
        }
        catch (error) {
            console.error('displayPowerOn failed', error);
        }
    });
    yield (0, effects_1.takeEvery)(devicePowerActionActions_1.TriggerAppletOff, function* () {
        try {
            yield (0, effects_1.put)({
                type: activeAppletActions_1.ActiveAppletRestore,
            });
        }
        catch (error) {
            console.error('displayPowerOff failed', error);
        }
    });
}
exports.deviceAppletDisablingRestoresActiveApplet = deviceAppletDisablingRestoresActiveApplet;
function* performPowerAction(getNativeDriver, propertyStorage, offlineCache, powerType) {
    const { frontDriver, cacheDriver } = (0, combinedDriver_1.normalizeFrontCacheDriver)(getNativeDriver());
    const deviceUid = yield frontDriver.getDeviceUid();
    switch (powerType) {
        case PowerActionType_1.default.APPLET_RELOAD:
            const fileUids = yield offlineCache.listFileUids('');
            yield Promise.all(fileUids.map((fileUid) => offlineCache.deleteFileAndDeleteDirectoryIfEmpty(fileUid, true)));
            const contents = yield cacheDriver.cacheGetAll();
            const contentKeysToDelete = Object.keys(contents).filter((key) => lodash_1.default.values(Property_1.default).indexOf(key) === -1);
            yield Promise.all(contentKeysToDelete.map((uid) => cacheDriver.cacheDelete(uid)));
            yield propertyStorage.removeValue(Property_1.default.APPLET_TIMINGS_UPDATE_DEFINITION);
            yield (0, effects_1.put)({
                type: appletActions_1.UpdateActiveAppletBinaryFile,
                appletBinaryFile: null,
                appletFrontAppletJsFile: null,
            });
            yield (0, effects_1.put)({ type: appletActions_1.UpdateActiveAppletUniqueHash, hash: (0, generator_1.generateUniqueHash)() });
            yield (0, effects_1.put)({ type: appletActions_1.SubscribeActiveApplet, deviceUid });
            yield (0, effects_1.put)({ type: activeAppletActions_1.ActiveAppletRestore });
            return true;
        case PowerActionType_1.default.APPLET_REFRESH:
            yield (0, effects_1.put)({ type: appletActions_1.UpdateActiveAppletUniqueHash, hash: (0, generator_1.generateUniqueHash)() });
            yield (0, effects_1.put)({ type: appletActions_1.SubscribeActiveApplet, deviceUid });
            yield (0, effects_1.put)({ type: activeAppletActions_1.ActiveAppletRestore });
        case PowerActionType_1.default.APPLET_ENABLE:
            yield (0, effects_1.put)({ type: devicePowerActionActions_1.TriggerAppletOn });
            return true;
        case PowerActionType_1.default.APPLET_DISABLE:
            yield (0, effects_1.put)({ type: devicePowerActionActions_1.TriggerAppletOff });
            return true;
        default:
            return false;
    }
}
function* performAppletRefresh() {
    yield (0, effects_1.put)({
        type: devicePowerActions_1.PerformPowerAction,
        powerType: PowerActionType_1.default.APPLET_RELOAD,
    });
}
exports.performAppletRefresh = performAppletRefresh;
//# sourceMappingURL=devicePowerActionSagas.js.map