"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.showNext = exports.iterate = void 0;
const appletTimingActions_1 = require("./appletTimingActions");
const TimingFinishEventType_1 = __importDefault(require("./TimingFinishEventType"));
const wait_1 = __importDefault(require("@signageos/lib/dist/Timer/wait"));
const defaultModel = {
    definitions: null,
    currentDefinitionIndex: null,
    startTimestamp: null,
    lastInteractionTimestamp: null,
    triggersPausedTimestamp: null,
    lastPutUpdateActiveAppletBinary: null,
    lastPutPrepareNextAppletTiming: null,
    deviceInConnectedMode: null,
};
class AppletTimingController {
    constructor(getCurrentTimestamp, postMessage) {
        this.getCurrentTimestamp = getCurrentTimestamp;
        this.postMessage = postMessage;
        this.model = defaultModel;
    }
    setModel(model) {
        this.model = model;
    }
    run() {
        return __awaiter(this, void 0, void 0, function* () {
            while (true) {
                try {
                    const message = iterate(this.model, this.getCurrentTimestamp);
                    if (message) {
                        this.postMessage(message);
                    }
                }
                catch (error) {
                    // do nothing
                }
                finally {
                    yield (0, wait_1.default)(100);
                }
            }
        });
    }
}
function iterate(model, getCurrentTimestamp) {
    if (model.definitions === null || model.definitions.length === 0) {
        // nothing to show
        return;
    }
    else if (model.triggersPausedTimestamp !== null) {
        // don't do anything if it's paused and try again later
        return;
    }
    else if (model.currentDefinitionIndex === null) {
        return { type: appletTimingActions_1.ShowNextAppletTiming };
    }
    else if (model.startTimestamp === null) {
        throw new Error('Unexpected state - start timestamp is null');
    }
    else {
        const currentDefinition = model.definitions[model.currentDefinitionIndex];
        if (showNext(currentDefinition, model.startTimestamp, model.lastInteractionTimestamp, getCurrentTimestamp())) {
            return { type: appletTimingActions_1.ShowNextAppletTiming };
        }
    }
}
exports.iterate = iterate;
function showNext(currentDefinition, startTimestamp, lastInteractionTimestamp, currentTimestamp) {
    switch (TimingFinishEventType_1.default[currentDefinition.finishEvent.type]) {
        case TimingFinishEventType_1.default.DURATION:
            return startTimestamp + parseFinishEventData(currentDefinition) <= currentTimestamp;
        case TimingFinishEventType_1.default.IDLE_TIMEOUT:
            if (lastInteractionTimestamp !== null && lastInteractionTimestamp > startTimestamp) {
                return lastInteractionTimestamp + parseFinishEventData(currentDefinition) <= currentTimestamp;
            }
            return startTimestamp + parseFinishEventData(currentDefinition) <= currentTimestamp;
        case TimingFinishEventType_1.default.SCREEN_TAP:
            return lastInteractionTimestamp !== null && lastInteractionTimestamp <= currentTimestamp;
        default:
            throw new Error('Invalid timing finish event type: ' + currentDefinition.finishEvent.type);
    }
}
exports.showNext = showNext;
function parseFinishEventData(definition) {
    switch (TimingFinishEventType_1.default[definition.finishEvent.type]) {
        case TimingFinishEventType_1.default.DURATION:
            return definition.finishEvent.data !== null ? parseInt(definition.finishEvent.data) : 60e3;
        case TimingFinishEventType_1.default.IDLE_TIMEOUT:
            return definition.finishEvent.data !== null ? parseInt(definition.finishEvent.data) : 30e3;
        case TimingFinishEventType_1.default.SCREEN_TAP:
            throw new Error('Unsupported event data for type: ' + definition.finishEvent.type);
        default:
            throw new Error('Unrecognized type of finishEvent: ' + definition.finishEvent.type);
    }
}
exports.default = AppletTimingController;
//# sourceMappingURL=AppletTimingController.js.map