"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.sendMessageToActiveAppletIfExists = void 0;
const wait_1 = __importDefault(require("@signageos/lib/dist/Timer/wait"));
const debug_1 = __importDefault(require("debug"));
const debug = (0, debug_1.default)('@signageos/front-display:Front:Applet:sendAppletMessage');
function sendAppletMessage(window, appletIframeId, message) {
    return __awaiter(this, void 0, void 0, function* () {
        if (appletIframeId === null) {
            throw new Error('Iframe id is null in sendAppletMessage');
        }
        const appletIframe = window.document.getElementById(appletIframeId);
        if (!appletIframe) {
            throw new Error('Not found active applet iframe by id ' + appletIframeId);
        }
        yield (0, wait_1.default)(0);
        if (!appletIframe.contentWindow) {
            throw new Error('Iframe with id ' + appletIframeId + ' was removed. ' + 'postMessage(' + JSON.stringify(message) + ') was not processed');
        }
        debug('sending message to applet ' + appletIframeId, message);
        appletIframe.contentWindow.window.postMessage(message, '*');
    });
}
exports.default = sendAppletMessage;
function sendMessageToActiveAppletIfExists(window, getState, message) {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            const appletIframeId = getState().applet.activeAppletIframeId;
            if (appletIframeId) {
                yield sendAppletMessage(window, appletIframeId, message);
            }
            else {
                debug('no active applet for message', message);
            }
        }
        catch (error) {
            debug('sendMessageToActiveAppletIfExists failed', error);
        }
    });
}
exports.sendMessageToActiveAppletIfExists = sendMessageToActiveAppletIfExists;
//# sourceMappingURL=sendAppletMessage.js.map