"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.notifyAppletTelemetry = exports.bindAppletIframe = exports.bindAppletMessages = exports.updateAppletDeviceAuthHash = exports.updateAppletUniqueHash = void 0;
const activeAppletActions_1 = require("@signageos/actions/dist/Applet/activeAppletActions");
const appletActions_1 = require("@signageos/actions/dist/Applet/appletActions");
const deviceAuthenticationActions_1 = require("@signageos/actions/dist/Device/Authentication/deviceAuthenticationActions");
const generator_1 = require("@signageos/lib/dist/Hash/generator");
const debug_1 = __importDefault(require("debug"));
const redux_saga_1 = require("redux-saga");
const effects_1 = require("redux-saga/effects");
const dependencyInjection_1 = require("../../DI/dependencyInjection");
const combinedDriver_1 = require("../../NativeDevice/Default/combinedDriver");
const socketActionCreator_1 = require("../../Socket/socketActionCreator");
const appletTimingActions_1 = require("../AppletTiming/appletTimingActions");
const errorHelper_1 = require("./Error/errorHelper");
const sendAppletMessage_1 = __importStar(require("./sendAppletMessage"));
const appletMessageHandler = __importStar(require("./appletMessageHandler"));
const ManagementCapability_1 = __importDefault(require("../../NativeDevice/Management/ManagementCapability"));
const DeviceTelemetryType_1 = require("@signageos/common-types/dist/Device/Telemetry/DeviceTelemetryType");
const Property_1 = __importDefault(require("../../Property/Property"));
const deviceTelemetryActions_1 = require("@signageos/actions/dist/Device/Telemetry/deviceTelemetryActions");
const lodash_1 = require("lodash");
const socketActionDeliverHelper_1 = require("../../Socket/socketActionDeliverHelper");
const debug = (0, debug_1.default)('@signageos/front-display:Front:Applet:appletSagas');
function* updateAppletUniqueHash() {
    let activeAppletUniqueHash = null;
    let lastUpdateActiveAppletBinary = null;
    yield (0, socketActionCreator_1.takeEveryAndBindWhenPlatform)(appletActions_1.UpdateActiveAppletUniqueHash, function* (updateActiveAppletUniqueHash) {
        activeAppletUniqueHash = updateActiveAppletUniqueHash.hash;
    });
    yield (0, effects_1.takeEvery)(appletTimingActions_1.HideOSD, function* () {
        lastUpdateActiveAppletBinary = null;
    });
    yield (0, socketActionCreator_1.takeEveryAndBindWhenPlatform)(appletActions_1.UpdateActiveAppletBinary, function* (updateActiveAppletBinary) {
        try {
            const changed = !lastUpdateActiveAppletBinary ||
                lastUpdateActiveAppletBinary.activeAppletUid !== updateActiveAppletBinary.activeAppletUid ||
                lastUpdateActiveAppletBinary.activeAppletVersion !== updateActiveAppletBinary.activeAppletVersion ||
                JSON.stringify(lastUpdateActiveAppletBinary.activeConfiguration) !== JSON.stringify(updateActiveAppletBinary.activeConfiguration);
            if (changed || activeAppletUniqueHash === null) {
                yield (0, effects_1.put)({
                    type: appletActions_1.UpdateActiveAppletUniqueHash,
                    hash: (0, generator_1.generateUniqueHash)(),
                });
            }
            lastUpdateActiveAppletBinary = updateActiveAppletBinary;
        }
        catch (error) {
            console.error('updateAppletUniqueHash failed', error);
        }
    });
}
exports.updateAppletUniqueHash = updateAppletUniqueHash;
function* updateAppletDeviceAuthHash(messageTypePrefix, window, getState) {
    yield (0, socketActionCreator_1.bindAndTakeEvery)(deviceAuthenticationActions_1.UpdateAuthentication, function* (action) {
        const deviceAuthHash = action.authHash;
        yield (0, sendAppletMessage_1.sendMessageToActiveAppletIfExists)(window, getState, {
            type: messageTypePrefix + '.auth_hash.update',
            authHash: deviceAuthHash,
        });
    });
}
exports.updateAppletDeviceAuthHash = updateAppletDeviceAuthHash;
function* bindAppletMessages(messageTypePrefix, window, getState, getNativeDriver, getSynchronizer, offlineCache, shortAppletFilesUrl, timerStorage) {
    const messageChannel = createMessageEventChannel(window);
    function* callback(managementDriver, applicationVersion, event) {
        try {
            const data = event.data;
            const appletState = getState().applet;
            let appletUid;
            let iframeId;
            let timingChecksum;
            const activeAppletIframe = appletState.activeAppletIframeId && window.document.getElementById(appletState.activeAppletIframeId);
            const nextAppletIframe = appletState.nextApplet &&
                appletState.nextApplet.iframeId &&
                window.document.getElementById(appletState.nextApplet.iframeId);
            if (activeAppletIframe && event.source === activeAppletIframe.contentWindow) {
                appletUid = appletState.activeAppletUid;
                iframeId = appletState.activeAppletIframeId;
                timingChecksum = appletState.activeTimingChecksum;
            }
            else if (nextAppletIframe && event.source === nextAppletIframe.contentWindow) {
                appletUid = appletState.nextApplet.uid;
                iframeId = appletState.nextApplet.iframeId;
                timingChecksum = appletState.nextApplet.timingChecksum;
            }
            else {
                // Silent not continuing on unknown source window
                return;
            }
            if (!appletUid) {
                throw new Error('Applet UID is not set');
            }
            if (!timingChecksum) {
                throw new Error('Timing checksum is not set');
            }
            const invocationUid = data.invocationUid;
            try {
                debug('handle message from applet: ' + data.type, data);
                const response = yield (0, effects_1.call)(handleAppletMessage, messageTypePrefix, data, appletUid, timingChecksum, getNativeDriver, () => managementDriver, getSynchronizer, offlineCache, window, getState, applicationVersion, shortAppletFilesUrl, timerStorage);
                debug('message OK: ' + data.type, data);
                yield (0, effects_1.call)(sendAppletMessage_1.default, window, iframeId, Object.assign({ type: messageTypePrefix + '.invocation.success', invocationUid }, response));
            }
            catch (error) {
                debug('message FAILED: ' + data.type, data);
                yield (0, effects_1.call)(sendAppletMessage_1.default, window, iframeId, {
                    type: messageTypePrefix + '.invocation.error',
                    invocationUid,
                    error: (0, errorHelper_1.createErrorTransferObject)(error),
                });
            }
        }
        catch (error) {
            debug('bindAppletMassages failed', error);
        }
    }
    yield (0, effects_1.fork)((0, dependencyInjection_1.withDependencies)(['managementDriver', 'applicationVersion'], function* ({ managementDriver, applicationVersion }) {
        yield (0, effects_1.takeEvery)(messageChannel, callback, managementDriver, applicationVersion);
    }));
}
exports.bindAppletMessages = bindAppletMessages;
function* handleAppletMessage(messageTypePrefix, data, appletUid, timingChecksum, getNativeDriver, getManagementDriver, getSynchronizer, offlineCache, window, getState, applicationVersion, shortAppletFilesUrl, timerStorage) {
    debug('Handling applet message', data, appletUid, timingChecksum);
    const { frontDriver, cacheDriver } = (0, combinedDriver_1.normalizeFrontCacheDriver)(getNativeDriver());
    return yield appletMessageHandler.handleAppletMessage({
        data,
        window,
        appletUid,
        offlineCache,
        timingChecksum,
        messageTypePrefix,
        synchronizer: getSynchronizer(),
        frontDriver,
        cacheDriver,
        managementDriver: getManagementDriver(),
        getState,
        applicationVersion,
        shortAppletFilesUrl,
        timerStorage,
    });
}
function* bindAppletIframe(messageTypePrefix, window, getState, frontDisplayVersion, getNativeDriver) {
    const iframeReadyPromises = {};
    yield (0, effects_1.takeEvery)(appletTimingActions_1.CreateAppletIframe, function* (action) {
        iframeReadyPromises[action.id] = initializeApplet(window, action.uid, action.id, messageTypePrefix, getState, frontDisplayVersion, getNativeDriver);
    });
    yield (0, effects_1.takeEvery)(appletTimingActions_1.RemoveAppletIframe, function* (action) {
        delete iframeReadyPromises[action.id];
    });
    yield (0, effects_1.takeEvery)(appletTimingActions_1.StartAppletIframe, function* (action) {
        var _a;
        try {
            const state = getState();
            const appletIframeId = action.id;
            const appletUid = action.uid;
            if (iframeReadyPromises[appletIframeId]) {
                yield iframeReadyPromises[appletIframeId];
            }
            else {
                yield initializeApplet(window, appletUid, appletIframeId, messageTypePrefix, getState, frontDisplayVersion, getNativeDriver);
            }
            const timingChecksum = (_a = state.applet.activeTimingChecksum) !== null && _a !== void 0 ? _a : '';
            yield (0, effects_1.put)({ type: activeAppletActions_1.ActiveAppletLoaded, appletUid, timingChecksum });
            if (state.deviceConnect.connectedBaseUrl) {
                yield (0, sendAppletMessage_1.default)(window, appletIframeId, {
                    type: messageTypePrefix + '.connect.update',
                    connectedBaseUrl: state.deviceConnect.connectedBaseUrl,
                });
            }
            const deviceAuthHash = state.deviceAuthentication.authHash;
            yield (0, sendAppletMessage_1.default)(window, appletIframeId, {
                type: messageTypePrefix + '.auth_hash.update',
                authHash: deviceAuthHash,
            });
            yield (0, effects_1.put)({ type: activeAppletActions_1.ActiveAppletReady, appletUid, timingChecksum });
        }
        catch (error) {
            debug('bindAppletIframe failed', error);
        }
    });
}
exports.bindAppletIframe = bindAppletIframe;
function initializeApplet(window, appletUid, iframeId, messageTypePrefix, getState, frontDisplayVersion, managementDriver) {
    return __awaiter(this, void 0, void 0, function* () {
        const state = getState();
        let appletConfiguration = state.applet.activeAppletConfiguration;
        let frontAppletJsFile = state.applet.activeAppletFrontAppletJsFile;
        let hasBundledFrontApplet = state.applet.activeAppletHasBundledFrontApplet;
        let appletVersion = state.applet.activeAppletVersion;
        if (state.applet.nextApplet && appletUid === state.applet.nextApplet.uid) {
            appletConfiguration = state.applet.nextApplet.configuration;
            frontAppletJsFile = state.applet.nextApplet.appletFrontAppletJsFile;
            hasBundledFrontApplet = state.applet.nextApplet.hasBundledFrontApplet;
            appletVersion = state.applet.nextApplet.appletVersion;
        }
        if (!hasBundledFrontApplet) {
            yield waitForAppletMessage(window, iframeId, messageTypePrefix + '_loader.ready');
            if (!frontAppletJsFile) {
                throw new Error('Front applet js file was not loaded yet');
            }
            yield (0, sendAppletMessage_1.default)(window, iframeId, {
                type: messageTypePrefix + '.api_js_uri',
                uri: frontAppletJsFile.localUri,
            });
        }
        yield waitForAppletMessage(window, iframeId, messageTypePrefix + '_api.ready');
        yield (0, sendAppletMessage_1.default)(window, iframeId, {
            type: messageTypePrefix + '.front_display_version.update',
            version: frontDisplayVersion,
        });
        yield (0, sendAppletMessage_1.default)(window, iframeId, {
            type: messageTypePrefix + '.applet_version.update',
            version: appletVersion,
        });
        const newConfig = yield handleDecryptedFields(state, appletConfiguration, managementDriver);
        yield (0, sendAppletMessage_1.default)(window, iframeId, {
            type: messageTypePrefix + '.config.update',
            config: newConfig,
        });
    });
}
function createMessageEventChannel(window) {
    const messageChannel = (0, redux_saga_1.channel)(redux_saga_1.buffers.dropping(10));
    window.addEventListener('message', (event) => {
        messageChannel.put(event);
    });
    return messageChannel;
}
function waitForAppletMessage(window, appletIframeId, type) {
    const appletIframe = window.document.getElementById(appletIframeId);
    if (!appletIframe) {
        throw new Error('Not found active applet iframe by id ' + appletIframeId);
    }
    if (!appletIframe.contentWindow) {
        throw new Error('Not found active applet iframe contentWindow ' + appletIframeId);
    }
    const appletWindow = appletIframe.contentWindow.window;
    return new Promise((resolve) => {
        const messageListener = (event) => {
            const sourceWindow = event.source;
            if (sourceWindow === appletWindow) {
                const data = event.data;
                switch (data.type) {
                    case type:
                        window.removeEventListener('message', messageListener);
                        resolve();
                        break;
                    default:
                }
            }
        };
        window.addEventListener('message', messageListener);
    });
}
function handleDecryptedFields(state, appletConfiguration, managementDriver) {
    var _a;
    return __awaiter(this, void 0, void 0, function* () {
        const getEncryptedFields = ((_a = state.applet.activeAppletMetadata) === null || _a === void 0 ? void 0 : _a.encryptedConfig) || {};
        const encryptedKeys = Object.keys(getEncryptedFields);
        const isSupported = yield managementDriver().managementSupports(ManagementCapability_1.default.SECRETS);
        try {
            if (encryptedKeys.length > 0 && isSupported) {
                const newConfig = Object.assign({}, appletConfiguration);
                for (const key of encryptedKeys) {
                    const valueFromConfiguration = state.applet.activeAppletConfiguration[key];
                    if (valueFromConfiguration) {
                        const jweGeneral = JSON.parse(Buffer.from(valueFromConfiguration, 'base64').toString('utf-8'));
                        const decryptedValue = yield managementDriver().secretManager.decryptJweGeneralToUtf8(jweGeneral);
                        newConfig[key] = decryptedValue;
                    }
                }
                return newConfig;
            }
        }
        catch (error) {
            console.error('Failed to decrypt applet configuration', error);
        }
        return appletConfiguration;
    });
}
function* notifyAppletTelemetry(propertyStorage) {
    yield (0, effects_1.takeEvery)(appletActions_1.UpdateActiveAppletBinary, function* (action) {
        try {
            if (action.activeAppletUid && action.activeAppletUid && action.activeAppletVersion) {
                const currentAppletSetting = {
                    appletUid: action.activeAppletUid,
                    appletVersion: action.activeAppletVersion,
                    config: action.activeConfiguration,
                };
                const lastUpdated = yield propertyStorage.getValueOrDefault(Property_1.default.LATEST_REPORTED_SETTINGS_APPLET, {});
                if (!(0, lodash_1.isEqual)(lastUpdated, currentAppletSetting)) {
                    yield (0, socketActionDeliverHelper_1.deliver)({
                        type: deviceTelemetryActions_1.UpdateDeviceTelemetryRecord,
                        name: DeviceTelemetryType_1.DeviceTelemetryType.APPLET,
                        data: currentAppletSetting,
                    });
                    yield propertyStorage.setValue(Property_1.default.LATEST_REPORTED_SETTINGS_APPLET, currentAppletSetting);
                }
            }
        }
        catch (error) {
            console.error('notifyAppletTelemetry failed', error);
        }
    });
}
exports.notifyAppletTelemetry = notifyAppletTelemetry;
//# sourceMappingURL=appletSagas.js.map