"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.applet = void 0;
const appletActions_1 = require("@signageos/actions/dist/Applet/appletActions");
const appletTimingActions_1 = require("../AppletTiming/appletTimingActions");
const devicePowerActionActions_1 = require("../Device/Power/devicePowerActionActions");
const licenseActions_1 = require("../License/licenseActions");
const initialState = {
    isCachedAppletReady: false,
    activeAppletUid: null,
    activeAppletConfiguration: null,
    activeAppletMissing: false,
    activeAppletUniqueHash: null,
    activeAppletIframeId: null,
    activeAppletVersion: null,
    activeTimingChecksum: null,
    activeAppletBinaryFile: null,
    activeAppletFrontAppletJsFile: null,
    activeAppletHasBundledFrontApplet: false,
    appletIsMuted: false,
    nextApplet: null,
    activeAppletMetadata: {},
    lastOpenedOSDTime: 0,
};
const OSD_UID = 'osd';
function applet(state = initialState, action) {
    switch (action.type) {
        case appletActions_1.UpdateActiveAppletBinary:
            const changed = state.activeAppletUid !== action.activeAppletUid ||
                state.activeAppletVersion !== action.activeAppletVersion ||
                JSON.stringify(state.activeAppletConfiguration) !== JSON.stringify(action.activeConfiguration);
            return Object.assign(Object.assign({}, state), { activeAppletUid: action.activeAppletUid, activeAppletConfiguration: action.activeConfiguration, activeTimingChecksum: action.activeTimingChecksum, activeAppletVersion: action.activeAppletVersion, activeAppletMissing: false, activeAppletUniqueHash: changed ? null : state.activeAppletUniqueHash, activeAppletIframeId: changed ? null : state.activeAppletIframeId, activeAppletBinaryFile: changed ? null : state.activeAppletBinaryFile, activeAppletFrontAppletJsFile: changed ? null : state.activeAppletFrontAppletJsFile, activeAppletHasBundledFrontApplet: changed ? !action.activeAppletFrontAppletVersion : state.activeAppletHasBundledFrontApplet, nextApplet: null, activeAppletMetadata: action.activeAppletMetadata });
        case appletTimingActions_1.ShowOSD:
            return Object.assign(Object.assign({}, state), { activeAppletUid: OSD_UID, activeAppletConfiguration: {}, activeTimingChecksum: OSD_UID, activeAppletVersion: null, activeAppletMissing: false, activeAppletUniqueHash: OSD_UID, activeAppletIframeId: null, activeAppletBinaryFile: action.appletBinaryFile, activeAppletFrontAppletJsFile: null, activeAppletHasBundledFrontApplet: true, nextApplet: null });
        case appletTimingActions_1.ShowOSDTime:
            return Object.assign(Object.assign({}, state), { lastOpenedOSDTime: action.time });
        case appletTimingActions_1.HideApplet:
            return Object.assign(Object.assign({}, state), { activeAppletMissing: true });
        case appletActions_1.SubscribeActiveApplet:
            return Object.assign(Object.assign({}, state), { activeAppletMissing: false });
        case appletActions_1.UpdateActiveAppletUniqueHash:
            return Object.assign(Object.assign({}, state), { activeAppletUniqueHash: action.hash });
        case appletTimingActions_1.CreateAppletIframe:
            const createAppletIframeUid = action.uid;
            const createAppletIframeId = action.id;
            if (state.activeAppletUid === createAppletIframeUid) {
                return Object.assign(Object.assign({}, state), { activeAppletIframeId: createAppletIframeId });
            }
            else if (state.nextApplet && state.nextApplet.uid === createAppletIframeUid) {
                return Object.assign(Object.assign({}, state), { nextApplet: Object.assign(Object.assign({}, state.nextApplet), { iframeId: createAppletIframeId }) });
            }
            return state;
        case appletTimingActions_1.StartAppletIframe:
            return Object.assign(Object.assign({}, state), { activeAppletIframeId: action.id });
        case appletActions_1.UpdateActiveAppletBinaryFile:
            return Object.assign(Object.assign({}, state), { activeAppletBinaryFile: action.appletBinaryFile, activeAppletFrontAppletJsFile: action.appletFrontAppletJsFile });
        case devicePowerActionActions_1.TriggerAppletOn:
            return Object.assign(Object.assign({}, state), { appletIsMuted: false });
        case devicePowerActionActions_1.TriggerAppletOff:
            return Object.assign(Object.assign({}, state), { appletIsMuted: true });
        case licenseActions_1.ChangeLicenseState:
            return Object.assign(Object.assign({}, state), { appletIsMuted: action.severity !== licenseActions_1.ViolationSeverity.none });
        case appletTimingActions_1.PrepareNextAppletTiming:
            return Object.assign(Object.assign({}, state), { nextApplet: {
                    uid: action.appletUid,
                    configuration: action.configuration,
                    timingChecksum: action.timingChecksum,
                    appletVersion: action.appletVersion,
                    appletFrontAppletVersion: action.appletFrontAppletVersion || null,
                    appletBinaryFile: null,
                    appletFrontAppletJsFile: null,
                    hasBundledFrontApplet: !!action.appletFrontAppletVersion,
                    iframeId: null,
                    metadata: action.appletMetadata,
                } });
        case appletTimingActions_1.UpdateNextAppletBinaryFile:
            if (state.nextApplet && state.nextApplet.uid === action.appletUid) {
                return Object.assign(Object.assign({}, state), { nextApplet: Object.assign(Object.assign({}, state.nextApplet), { appletBinaryFile: action.appletBinaryFile, appletFrontAppletJsFile: action.appletFrontAppletJsFile }) });
            }
            else {
                return state;
            }
        case appletActions_1.UpdateAppletTimingsDefinition:
            return Object.assign(Object.assign({}, state), { isCachedAppletReady: action.definitions.length > 0, activeAppletMetadata: action.definitions[0].metadata });
        default:
            return state;
    }
}
exports.applet = applet;
//# sourceMappingURL=appletReducers.js.map