import { IFile as IFileSystemFile } from '../../NativeDevice/fileSystem';
import { UpdateActiveAppletBinary, SubscribeActiveApplet, UpdateActiveAppletUniqueHash, UpdateActiveAppletBinaryFile, UpdateAppletTimingsDefinition } from '@signageos/actions/dist/Applet/appletActions';
import { CreateAppletIframe, StartAppletIframe, PrepareNextAppletTiming, UpdateNextAppletBinaryFile, ShowOSD, HideApplet, ShowOSDTime } from '../AppletTiming/appletTimingActions';
import { TriggerDisplayPowerOn, TriggerDisplayPowerOff, TriggerAppletOn, TriggerAppletOff } from '../Device/Power/devicePowerActionActions';
import { ChangeLicenseState } from '../License/licenseActions';
export interface IAppletState {
    isCachedAppletReady: boolean;
    activeAppletUid: string | null;
    activeAppletConfiguration: any | null;
    activeAppletMissing: boolean;
    activeAppletUniqueHash: string | null;
    activeAppletIframeId: string | null;
    activeAppletVersion: string | null;
    activeTimingChecksum: string | null;
    activeAppletBinaryFile: IFileSystemFile | null;
    activeAppletFrontAppletJsFile: IFileSystemFile | null;
    activeAppletHasBundledFrontApplet: boolean;
    appletIsMuted: boolean;
    nextApplet: null | {
        uid: string;
        configuration: any;
        timingChecksum: string;
        appletVersion: string;
        appletFrontAppletVersion: string | null;
        appletBinaryFile: IFileSystemFile | null;
        appletFrontAppletJsFile: IFileSystemFile | null;
        hasBundledFrontApplet: boolean;
        iframeId: string | null;
        metadata: any;
    };
    activeAppletMetadata?: {
        encryptedConfig?: Record<string, string>;
    };
    lastOpenedOSDTime: number;
}
export declare function applet(state: IAppletState | undefined, action: TriggerDisplayPowerOn | TriggerDisplayPowerOff | UpdateActiveAppletBinary | UpdateActiveAppletUniqueHash | UpdateAppletTimingsDefinition | CreateAppletIframe | StartAppletIframe | UpdateActiveAppletBinaryFile | PrepareNextAppletTiming | UpdateNextAppletBinaryFile | TriggerAppletOn | TriggerAppletOff | ChangeLicenseState | ShowOSD | ShowOSDTime | HideApplet | SubscribeActiveApplet): IAppletState;
