"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const FRONT_APPLET_JS_UID = 'front-applet';
const LAST_APPLET_BINARY_UID = 'applet';
const createAppletFileNameHelpers = (shortAppletFilesUrl) => {
    const getLocalDirectoryPath = (appletUid, appletVersion, appletVersionPostfix) => {
        var _a;
        return [LAST_APPLET_BINARY_UID, shortAppletFilesUrl ? appletUid.slice(0, 8) : appletUid, appletVersion !== null && appletVersion !== void 0 ? appletVersion : 'latest']
            .concat((_a = (shortAppletFilesUrl ? appletVersionPostfix === null || appletVersionPostfix === void 0 ? void 0 : appletVersionPostfix.slice(0, 11) : appletVersionPostfix)) !== null && _a !== void 0 ? _a : [])
            .join('/');
    };
    const getRemoteDirectoryPath = (appletUid, appletVersion, appletVersionPostfix) => {
        return '/applet' + '/' + appletUid + '/' + appletVersion + (appletVersionPostfix ? '-' + appletVersionPostfix : '');
    };
    return {
        getLocalDirectoryPath,
        getRemoteDirectoryPath,
        getFrontAppletJsFileName: (frontAppletVersion) => {
            return FRONT_APPLET_JS_UID + '/' + frontAppletVersion + '.js';
        },
        getAppletBinaryFileName: (appletUid, appletVersion, appletVersionPostfix) => {
            return getLocalDirectoryPath(appletUid, appletVersion, appletVersionPostfix) + '/index.html';
        },
        getAppletPackageFilePath: (appletUid, appletVersion, appletVersionPostfix) => {
            return getLocalDirectoryPath(appletUid, appletVersion, appletVersionPostfix) + '/.package.zip';
        },
        getAppletPackageDirectoryPath: (appletUid, appletVersion, appletVersionPostfix) => {
            return getLocalDirectoryPath(appletUid, appletVersion, appletVersionPostfix) + '/package';
        },
        getAppletPackageConfigFilePath: (appletUid, appletVersion, appletVersionPostfix) => {
            return getLocalDirectoryPath(appletUid, appletVersion, appletVersionPostfix) + '/package/package.json';
        },
        getAppletBinaryFileUri: (staticBaseUrl, appletUid, appletVersion, appletVersionPostfix) => {
            return staticBaseUrl + getRemoteDirectoryPath(appletUid, appletVersion, appletVersionPostfix) + '/index.html';
        },
        getAppletPackageFileUri: (staticBaseUrl, appletUid, appletVersion, appletVersionPostfix) => {
            return staticBaseUrl + getRemoteDirectoryPath(appletUid, appletVersion, appletVersionPostfix) + '/.package.zip';
        },
    };
};
exports.default = createAppletFileNameHelpers;
//# sourceMappingURL=appletFileNameHelpers.js.map