"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.updateActiveAppletBinaryFile = exports.activeAppletBinary = void 0;
const socketActionCreator_1 = require("../../Socket/socketActionCreator");
const effects_1 = require("redux-saga/effects");
const authenticationActions_1 = require("@signageos/actions/dist/Authentication/authenticationActions");
const deviceVerificationActions_1 = require("@signageos/actions/dist/Device/Verification/deviceVerificationActions");
const appletActions_1 = require("@signageos/actions/dist/Applet/appletActions");
const appletTimingActions_1 = require("../AppletTiming/appletTimingActions");
const AppletBinaryDownloader_1 = require("./AppletBinaryDownloader");
const dependencyInjection_1 = require("../../DI/dependencyInjection");
function* activeAppletBinary(getState, getNativeDriver) {
    yield (0, socketActionCreator_1.bindAndTakeEvery)([authenticationActions_1.AuthenticationSucceed, deviceVerificationActions_1.VerificationSucceeded], function* (action) {
        try {
            const deviceUid = yield getNativeDriver().getDeviceUid();
            switch (action.type) {
                case authenticationActions_1.AuthenticationSucceed:
                    const state = getState();
                    if (state.deviceVerification.verified) {
                        yield (0, effects_1.put)({
                            type: appletActions_1.SubscribeActiveApplet,
                            deviceUid,
                        });
                    }
                    break;
                case deviceVerificationActions_1.VerificationSucceeded:
                    yield (0, effects_1.put)({
                        type: appletActions_1.SubscribeActiveApplet,
                        deviceUid,
                    });
                    break;
                default:
            }
        }
        catch (error) {
            console.error('activeAppletBinary failed', error);
        }
    });
}
exports.activeAppletBinary = activeAppletBinary;
function* updateActiveAppletBinaryFile(shortAppletFilesUrl, offlineCache, defaultTimingData) {
    let staticBaseUrl = null;
    yield (0, effects_1.fork)(function* () {
        const { staticBaseUrl: staticBaseUrlFromState } = yield (0, dependencyInjection_1.awaitDependencies)(['staticBaseUrl']);
        staticBaseUrl = staticBaseUrlFromState;
    });
    yield (0, effects_1.fork)((0, dependencyInjection_1.withDependencies)(['connectedBaseUrl'], function* ({ connectedBaseUrl }) {
        const getStaticBaseUrl = () => {
            const finalStaticBaseUrl = connectedBaseUrl !== null && connectedBaseUrl !== void 0 ? connectedBaseUrl : staticBaseUrl;
            if (finalStaticBaseUrl === null) {
                throw new Error(`The applet is not downloaded and is trying to download before the staticBaseUrl is set.`);
            }
            return finalStaticBaseUrl;
        };
        const appletBinaryDownloader = new AppletBinaryDownloader_1.AppletBinaryDownloader(shortAppletFilesUrl, offlineCache, getStaticBaseUrl);
        yield (0, socketActionCreator_1.takeEveryAndBindWhenPlatform)(appletActions_1.UpdateActiveAppletBinary, function* (updateActiveAppletBinary) {
            var _a;
            try {
                const { frontAppletJsFile, appletBinaryFile } = yield appletBinaryDownloader.getOrDownloadAppletBinaries(updateActiveAppletBinary.activeAppletUid, updateActiveAppletBinary.activeAppletVersion, (_a = updateActiveAppletBinary.activeAppletIsPackage) !== null && _a !== void 0 ? _a : false, updateActiveAppletBinary.activeAppletFrontAppletVersion || updateActiveAppletBinary.activeAppletHugApiVersion, // deprecated will be deleted
                updateActiveAppletBinary.activeAppletVersionPostfix, defaultTimingData);
                yield (0, effects_1.put)({
                    type: appletActions_1.UpdateActiveAppletBinaryFile,
                    appletBinaryFile,
                    appletFrontAppletJsFile: frontAppletJsFile,
                });
            }
            catch (error) {
                console.error('updateActiveAppletBinaryFile failed', error);
            }
        });
        yield (0, effects_1.takeEvery)(appletTimingActions_1.PrepareNextAppletTiming, function* (action) {
            try {
                const { frontAppletJsFile, appletBinaryFile } = yield appletBinaryDownloader.getOrDownloadAppletBinaries(action.appletUid, action.appletVersion, action.isPackage, action.appletFrontAppletVersion, action.appletVersionPostfix, defaultTimingData);
                yield (0, effects_1.put)({
                    type: appletTimingActions_1.UpdateNextAppletBinaryFile,
                    appletUid: action.appletUid,
                    appletBinaryFile,
                    appletFrontAppletJsFile: frontAppletJsFile,
                });
            }
            catch (error) {
                console.error('prepareNextAppletTiming failed', error);
            }
        });
    }));
}
exports.updateActiveAppletBinaryFile = updateActiveAppletBinaryFile;
//# sourceMappingURL=appletBinarySagas.js.map