"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.handleTouchMessage = void 0;
const effects_1 = require("redux-saga/effects");
const motionActions_1 = require("@signageos/actions/dist/Input/motionActions");
const GestureAction_1 = __importDefault(require("../../../NativeDevice/Input/GestureAction"));
const touchGestureResolver_1 = require("../../Touch/touchGestureResolver");
const debug_1 = __importDefault(require("debug"));
const debug = (0, debug_1.default)('@signageos/front-display:Front:Applet:Touch:appletTouchHandler');
function* handleTouchMessage(messageTypePrefix, data, _nativeDriver, _window, _appletUid, _timingChecksum) {
    switch (data.type) {
        case messageTypePrefix + '.touch.event':
            try {
                const gestures = (0, touchGestureResolver_1.handleTouch)(data.eventType);
                if (gestures.length > 0) {
                    for (let gesture of gestures) {
                        yield (0, effects_1.put)({
                            type: motionActions_1.HandleMotion,
                            gestureAction: GestureAction_1.default[gesture],
                        });
                    }
                }
            }
            catch (error) {
                debug('handleTouchMessage failed', error);
            }
            return {};
        default:
            return null;
    }
}
exports.handleTouchMessage = handleTouchMessage;
function* touchHandler({ messageTypePrefix, data, frontDriver, window, appletUid, timingChecksum, }) {
    return yield handleTouchMessage(messageTypePrefix, data, frontDriver, window, appletUid, timingChecksum);
}
exports.default = touchHandler;
//# sourceMappingURL=appletTouchHandler.js.map