import IDriver from '../../../NativeDevice/Front/IFrontDriver';
import { HandlerResult, IHandlerParams } from '../IHandler';
import { IStreamGetTracksMessage, IStreamPauseMessage, IStreamPlayMessage, IStreamPrepareMessage, IStreamResetTrackMessage, IStreamResumeMessage, IStreamSelectTrackMessage, IStreamStopMessage } from './appletStreamMessages';
import { ITrackInfo } from '../../../Stream/IStreamPlayer';
export declare function handleStreamMessage(messageTypePrefix: string, data: IStreamPrepareMessage | IStreamPlayMessage | IStreamStopMessage | IStreamPauseMessage | IStreamResumeMessage | IStreamGetTracksMessage | IStreamSelectTrackMessage | IStreamResetTrackMessage, nativeDriver: IDriver, appletUid: string, timingChecksum: string): HandlerResult;
export declare function handleStreamPrepare(data: IStreamPrepareMessage, nativeDriver: IDriver): HandlerResult;
export declare function handleStreamPlay(messageTypePrefix: string, data: IStreamPlayMessage, nativeDriver: IDriver, appletUid: string, timingChecksum: string): HandlerResult;
export declare function handleStreamStop(data: IStreamStopMessage, nativeDriver: IDriver, appletUid: string, timingChecksum: string): HandlerResult;
export declare function handleStreamPause(data: IStreamStopMessage, nativeDriver: IDriver): Generator<Promise<void>, void, unknown>;
export declare function handleStreamResume(data: IStreamStopMessage, nativeDriver: IDriver): Generator<Promise<void>, void, unknown>;
export declare function handleStreamGetTracks(data: IStreamGetTracksMessage, nativeDriver: IDriver): Generator<Promise<ITrackInfo[]>, {
    tracks: ITrackInfo[];
}, ITrackInfo[]>;
export declare function handleStreamSelectTrack(data: IStreamSelectTrackMessage, nativeDriver: IDriver): Generator<Promise<void>, void, unknown>;
export declare function handleStreamResetTrack(data: IStreamResetTrackMessage, nativeDriver: IDriver): Generator<Promise<void>, void, unknown>;
export declare function resolveProtocolType(data: IStreamPrepareMessage): string | undefined;
export default function streamHandler({ messageTypePrefix, data, frontDriver, appletUid, timingChecksum }: IHandlerParams): HandlerResult;
