"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.proximitySensorStatusChangeEmitting = void 0;
const effects_1 = require("redux-saga/effects");
const sendAppletMessage_1 = require("../sendAppletMessage");
const applicationActions_1 = require("@signageos/actions/dist/Application/applicationActions");
const channels_1 = require("../../../ReduxSaga/channels");
function* proximitySensorStatusChangeEmitting(window, messageTypePrefix, getNativeDriver, getState) {
    yield (0, effects_1.takeEvery)(applicationActions_1.StartApplication, function* () {
        try {
            const nativeDriver = getNativeDriver();
            const proximitySensorChangesChannel = (0, channels_1.createChannel)((put) => {
                nativeDriver.sensors.proximity.addStateChangeListener(put);
            });
            yield (0, channels_1.takeEvery)(proximitySensorChangesChannel, function* (detected) {
                yield (0, sendAppletMessage_1.sendMessageToActiveAppletIfExists)(window, getState, {
                    type: messageTypePrefix + '.sensors.proximity.change',
                    detected,
                });
            });
        }
        catch (error) {
            console.error('proximitySensorStatusChangeEmitting failed', error);
        }
    });
}
exports.proximitySensorStatusChangeEmitting = proximitySensorStatusChangeEmitting;
//# sourceMappingURL=appletProximitySensorSagas.js.map