"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.handleWifiMessage = void 0;
function* handleWifiMessage(messageTypePrefix, data, nativeDriver) {
    switch (data.type) {
        case messageTypePrefix + '.management.wifi.is_enabled':
            return yield isWifiClientEnabled(nativeDriver);
        case messageTypePrefix + '.management.wifi.get_connected_to':
            return yield getWifiConnectedTo(nativeDriver);
        case messageTypePrefix + '.management.wifi.enable':
            return yield enableWifiClient(nativeDriver);
        case messageTypePrefix + '.management.wifi.disable':
            return yield disableWifi(nativeDriver);
        case messageTypePrefix + '.management.wifi.is_ap_enabled':
            return yield isWifiAPEnabled(nativeDriver);
        case messageTypePrefix + '.management.wifi.enable_ap':
            return yield enableWifiAP(data, nativeDriver);
        case messageTypePrefix + '.management.wifi.connect':
            return yield connectWifi(data, nativeDriver);
        case messageTypePrefix + '.management.wifi.disconnect':
            return yield disconnectWifi(nativeDriver);
        case messageTypePrefix + '.management.wifi.get_country':
            return yield getCountry(nativeDriver);
        case messageTypePrefix + '.management.wifi.set_country':
            return yield setCountry(data, nativeDriver);
        case messageTypePrefix + '.management.wifi.scan':
            return yield scanWifiDevices(nativeDriver);
        default:
            return null;
    }
}
exports.handleWifiMessage = handleWifiMessage;
function isWifiClientEnabled(nativeDriver) {
    return __awaiter(this, void 0, void 0, function* () {
        const isEnabled = yield nativeDriver.wifi.isClientEnabled();
        return { isWifiEnabled: isEnabled };
    });
}
function getWifiConnectedTo(nativeDriver) {
    return __awaiter(this, void 0, void 0, function* () {
        const ssid = yield nativeDriver.wifi.getConnectedTo();
        return { ssid };
    });
}
function enableWifiClient(nativeDriver) {
    return __awaiter(this, void 0, void 0, function* () {
        yield nativeDriver.wifi.enableClient();
        return {};
    });
}
function disableWifi(nativeDriver) {
    return __awaiter(this, void 0, void 0, function* () {
        yield nativeDriver.wifi.disable();
        return {};
    });
}
function isWifiAPEnabled(nativeDriver) {
    return __awaiter(this, void 0, void 0, function* () {
        const isEnabled = yield nativeDriver.wifi.isAPEnabled();
        return { isWifiAPEnabled: isEnabled };
    });
}
function enableWifiAP(data, nativeDriver) {
    return __awaiter(this, void 0, void 0, function* () {
        yield nativeDriver.wifi.enableAP(data.ssid, data.password);
        return {};
    });
}
function connectWifi(data, nativeDriver) {
    return __awaiter(this, void 0, void 0, function* () {
        const password = data.password;
        if (password && (password.length < 8 || password.length > 63)) {
            throw new Error('Password must be between 8 and 63 characters long');
        }
        yield nativeDriver.wifi.connect(data.ssid, data.password, data.options);
        return {};
    });
}
function disconnectWifi(nativeDriver) {
    return __awaiter(this, void 0, void 0, function* () {
        yield nativeDriver.wifi.disconnect();
        return {};
    });
}
function getCountry(nativeDriver) {
    return __awaiter(this, void 0, void 0, function* () {
        const countryCode = yield nativeDriver.wifi.getCountry();
        return { countryCode };
    });
}
function setCountry(data, nativeDriver) {
    return __awaiter(this, void 0, void 0, function* () {
        yield nativeDriver.wifi.setCountry(data.countryCode);
        return {};
    });
}
function scanWifiDevices(nativeDriver) {
    return __awaiter(this, void 0, void 0, function* () {
        const devices = yield nativeDriver.wifi.scan();
        return { devices };
    });
}
function* wifiHandler({ messageTypePrefix, data, managementDriver }) {
    return yield handleWifiMessage(messageTypePrefix, data, managementDriver);
}
exports.default = wifiHandler;
//# sourceMappingURL=appletWifiHandler.js.map