"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.handleManagementSystemInfoMessage = void 0;
const PREFIX = 'management';
function* handleManagementSystemInfoMessage(messageTypePrefix, data, managementDriver) {
    switch (data.type) {
        case `${messageTypePrefix}.${PREFIX}.get_os_info`:
            return yield handleOSInfo(managementDriver);
        case `${messageTypePrefix}.${PREFIX}.get_cpu_usage`:
            return yield handleCpuUsage(managementDriver);
        case `${messageTypePrefix}.${PREFIX}.get_memory_usage`:
            return yield handleMemoryUsage(managementDriver);
        default:
            return null;
    }
}
exports.handleManagementSystemInfoMessage = handleManagementSystemInfoMessage;
function handleOSInfo(managementDriver) {
    return __awaiter(this, void 0, void 0, function* () {
        const osVersion = yield managementDriver.systemInfo.getOSVersion();
        return {
            osInfo: {
                version: osVersion,
            },
        };
    });
}
function handleCpuUsage(managementDriver) {
    return __awaiter(this, void 0, void 0, function* () {
        const cpuUsage = yield managementDriver.systemInfo.getCpuUsage();
        return {
            cpuUsage,
        };
    });
}
function handleMemoryUsage(managementDriver) {
    return __awaiter(this, void 0, void 0, function* () {
        const memoryUsage = yield managementDriver.systemInfo.getMemoryUsage();
        return {
            memoryUsage,
        };
    });
}
function* managementHandler({ messageTypePrefix, data, managementDriver }) {
    return yield handleManagementSystemInfoMessage(messageTypePrefix, data, managementDriver);
}
exports.default = managementHandler;
//# sourceMappingURL=appletManagementSystemInfoHandler.js.map