"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.handleManagementProxyMessage = void 0;
const PREFIX = 'management';
function* handleManagementProxyMessage(messageTypePrefix, data, managementDriver) {
    switch (data.type) {
        case `${messageTypePrefix}.${PREFIX}.proxy_is_enabled`:
            return yield handleIsEnabled(managementDriver);
        case `${messageTypePrefix}.${PREFIX}.proxy_set_manual`:
            return yield handleSetManual(managementDriver, data);
        case `${messageTypePrefix}.${PREFIX}.proxy_disable`:
            return yield handleDisable(managementDriver);
        case `${messageTypePrefix}.${PREFIX}.proxy_get_connected_to`:
            return yield handleGetConnectedTo(managementDriver);
        default:
            return null;
    }
}
exports.handleManagementProxyMessage = handleManagementProxyMessage;
function handleIsEnabled(managementDriver) {
    return __awaiter(this, void 0, void 0, function* () {
        const isEnabled = yield managementDriver.proxy.isEnabled();
        return {
            isEnabled,
        };
    });
}
function handleSetManual(managementDriver, data) {
    return __awaiter(this, void 0, void 0, function* () {
        yield managementDriver.proxy.setManual(data.uri, data.port, data.username, data.password);
        return {};
    });
}
function handleDisable(managementDriver) {
    return __awaiter(this, void 0, void 0, function* () {
        yield managementDriver.proxy.disable();
        return {};
    });
}
function handleGetConnectedTo(managementDriver) {
    return __awaiter(this, void 0, void 0, function* () {
        const connectedTo = yield managementDriver.proxy.getConnectedTo();
        return {
            connectedTo,
        };
    });
}
function* managementHandler({ messageTypePrefix, data, managementDriver }) {
    return yield handleManagementProxyMessage(messageTypePrefix, data, managementDriver);
}
exports.default = managementHandler;
//# sourceMappingURL=appletManagementProxyHandler.js.map