"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const effects_1 = require("redux-saga/effects");
const activeAppletActions_1 = require("@signageos/actions/dist/Applet/activeAppletActions");
function* handlePingMessage(messageTypePrefix, data, _nativeDriver, appletUid, timingChecksum) {
    switch (data.type) {
        case messageTypePrefix + '.ping':
            yield (0, effects_1.put)({
                type: activeAppletActions_1.AppletPing,
                appletUid,
                timingChecksum,
            });
            return {};
        default:
            return null;
    }
}
function* pingHandler({ messageTypePrefix, data, frontDriver, appletUid, timingChecksum }) {
    return yield handlePingMessage(messageTypePrefix, data, frontDriver, appletUid, timingChecksum);
}
exports.default = pingHandler;
//# sourceMappingURL=pingHandler.js.map