"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.handleHardwareMessage = void 0;
const InternalHardwareError_1 = __importDefault(require("../Error/InternalHardwareError"));
const ErrorCodes_1 = __importDefault(require("../Error/ErrorCodes"));
function* handleHardwareMessage(messageTypePrefix, data, nativeDriver, _appletUid, _timingChecksum) {
    switch (data.type) {
        case messageTypePrefix + '.hardware.led.set_color':
            try {
                yield nativeDriver.hardware.led.setColor(data.color);
            }
            catch (error) {
                throw new InternalHardwareError_1.default({
                    kind: 'internalHardwareErrorWithOrigin',
                    message: 'Unexpected error occurred when working with hardware.',
                    code: ErrorCodes_1.default.HARDWARE_SET_COLOR_ERROR,
                    origin: `setColor(${data.color})`,
                    originStack: error.stack,
                    originMessage: error.message,
                });
            }
            return {};
        default:
            return null;
    }
}
exports.handleHardwareMessage = handleHardwareMessage;
function* hardwareHandler({ messageTypePrefix, data, frontDriver, appletUid, timingChecksum, }) {
    return yield handleHardwareMessage(messageTypePrefix, data, frontDriver, appletUid, timingChecksum);
}
exports.default = hardwareHandler;
//# sourceMappingURL=appletHardwareHandler.js.map