import { HandlerResult, IHandlerParams } from '../IHandler';
export declare const DEFAULT_SCANNER_ID = 0;
export interface IScanners {
    [scannerId: number]: {
        status: BarcodeScannerStatus;
    };
}
export declare enum BarcodeScannerStatus {
    IDLE = 0,
    STARTING = 1,
    USED = 2,
    STOPPING = 3
}
export default function hardwareBarcodeScannerHandler({ messageTypePrefix, data, frontDriver, window, getState, }: Pick<IHandlerParams, 'messageTypePrefix' | 'data' | 'frontDriver' | 'window' | 'getState'>, mockScanners?: IScanners): HandlerResult;
