"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.storageStatusChangeEmitting = void 0;
const effects_1 = require("redux-saga/effects");
const sendAppletMessage_1 = require("../sendAppletMessage");
const applicationActions_1 = require("@signageos/actions/dist/Application/applicationActions");
const channels_1 = require("../../../ReduxSaga/channels");
function* storageStatusChangeEmitting(window, messageTypePrefix, getNativeDriver, getState) {
    yield (0, effects_1.takeEvery)(applicationActions_1.StartApplication, function* () {
        try {
            const nativeDriver = getNativeDriver();
            const storageChangesChannel = (0, channels_1.createChannel)((put) => nativeDriver.fileSystem.onStorageUnitsChanged(() => put(undefined)));
            yield (0, channels_1.takeEvery)(storageChangesChannel, function* () {
                yield (0, sendAppletMessage_1.sendMessageToActiveAppletIfExists)(window, getState, {
                    type: messageTypePrefix + '.file_system.storage_units_changed',
                });
            });
        }
        catch (error) {
            console.error('storageStatusChangeEmitting failed', error);
        }
    });
}
exports.storageStatusChangeEmitting = storageStatusChangeEmitting;
//# sourceMappingURL=appletFileSystemSagas.js.map