"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createErrorTransferObject = void 0;
const ErrorCodes_1 = __importDefault(require("./ErrorCodes"));
function createErrorTransferObject(error) {
    const errorTransferObject = {};
    errorTransferObject.type = error.name;
    errorTransferObject.message = error.message;
    errorTransferObject.stackTrace = error.stack;
    errorTransferObject.suggestion = error.suggestion;
    errorTransferObject.pathToDocs = error.pathToDocs;
    errorTransferObject.origin = error.origin;
    errorTransferObject.originStack = error.originStack;
    errorTransferObject.code = error.code ? error.code : ErrorCodes_1.default.UNEXPECTED_EXCEPTION;
    return errorTransferObject;
}
exports.createErrorTransferObject = createErrorTransferObject;
//# sourceMappingURL=errorHelper.js.map