"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const InternalError_1 = __importDefault(require("./InternalError"));
class InternalHardwareError extends InternalError_1.default {
    constructor(parameters) {
        if (parameters.kind === 'internalHardwareError') {
            super(Object.assign(Object.assign({}, parameters), { pathToDocs: InternalHardwareError.PATH_TO_DOCS, kind: 'internalError' }));
        }
        else {
            super(Object.assign(Object.assign({}, parameters), { pathToDocs: InternalHardwareError.PATH_TO_DOCS, kind: 'internalErrorWithOrigin' }));
        }
        this.name = 'InternalHardwareError';
    }
}
InternalHardwareError.PATH_TO_DOCS = '/api/js/js-hardware';
exports.default = InternalHardwareError;
//# sourceMappingURL=InternalHardwareError.js.map