import SosError, { IBaseSosErrorParams, IBaseSosErrorParamsWithDocs } from './SosError';
export interface IBaseInternalErrorParamsWithOrigin extends IBaseSosErrorParams {
    origin: string;
    originStack: string;
    originMessage: string;
}
export interface IInternalErrorParams extends IBaseSosErrorParamsWithDocs {
    kind: 'internalError';
}
export interface IInternalErrorParamsWithOrigin extends IBaseSosErrorParamsWithDocs {
    kind: 'internalErrorWithOrigin';
    origin: string;
    originStack: string;
    originMessage: string;
}
export default class InternalError extends SosError {
    origin?: string;
    originStack?: string;
    originMessage?: string;
    constructor(parameters: IInternalErrorParams | IInternalErrorParamsWithOrigin);
}
